/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.apache.commons.lang3.text.translate;

import com.google.repacked.apache.commons.lang3.text.translate.CharSequenceTranslator;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public final class LookupTranslator
extends CharSequenceTranslator {
    private final HashMap<String, CharSequence> lookupMap = new HashMap();
    private final int shortest;
    private final int longest;

    /*
     * WARNING - void declaration
     */
    public LookupTranslator(CharSequence[] ... lookup) {
        void var3_3;
        void var2_2;
        int _shortest = Integer.MAX_VALUE;
        int _longest = 0;
        if (lookup != null) {
            CharSequence[][] arr$ = lookup;
            int len$ = lookup.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                CharSequence[] seq = arr$[i$];
                this.lookupMap.put(seq[0].toString(), seq[1]);
                int sz = seq[0].length();
                if (sz < _shortest) {
                    _shortest = sz;
                }
                if (sz <= _longest) continue;
                _longest = sz;
            }
        }
        this.shortest = var2_2;
        this.longest = var3_3;
    }

    @Override
    public final int translate(CharSequence input, int index, Writer out) throws IOException {
        int max = this.longest;
        if (index + this.longest > input.length()) {
            max = input.length() - index;
        }
        for (int i = max; i >= this.shortest; --i) {
            CharSequence subSeq = input.subSequence(index, index + i);
            CharSequence result = this.lookupMap.get(subSeq.toString());
            if (result == null) continue;
            out.write(result.toString());
            return i;
        }
        return 0;
    }
}

