/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.apache.commons.lang3.text.translate;

import com.google.repacked.apache.commons.lang3.text.translate.CharSequenceTranslator;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;

public final class NumericEntityUnescaper
extends CharSequenceTranslator {
    private final EnumSet<OPTION> options = EnumSet.copyOf(Arrays.asList(OPTION.semiColonRequired));

    public NumericEntityUnescaper(OPTION ... options) {
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSet(OPTION option) {
        void var1_1;
        if (this.options == null) {
            return false;
        }
        return this.options.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int translate(CharSequence input, int index, Writer out) throws IOException {
        int seqEnd = input.length();
        if (input.charAt(index) == '&' && index < seqEnd - 2 && input.charAt(index + 1) == '#') {
            void var2_4;
            int entityValue22;
            int end;
            int start = index + 2;
            boolean isHex = false;
            char firstChar = input.charAt(start);
            if (firstChar == 'x' || firstChar == 'X') {
                isHex = true;
                if (++start == seqEnd) {
                    return 0;
                }
            }
            for (end = start; end < seqEnd && (input.charAt(end) >= '0' && input.charAt(end) <= '9' || input.charAt(end) >= 'a' && input.charAt(end) <= 'f' || input.charAt(end) >= 'A' && input.charAt(end) <= 'F'); ++end) {
            }
            boolean semiNext = end != seqEnd && input.charAt(end) == ';';
            if (!semiNext) {
                if (this.isSet(OPTION.semiColonRequired)) {
                    return 0;
                }
                if (this.isSet(OPTION.errorIfNoSemiColon)) {
                    throw new IllegalArgumentException("Semi-colon required at end of numeric entity");
                }
            }
            try {
                void entityValue22;
                entityValue22 = isHex ? Integer.parseInt(input.subSequence(start, end).toString(), 16) : Integer.parseInt(entityValue22.subSequence(start, end).toString(), 10);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
            if (entityValue22 > 65535) {
                void var1_3;
                char[] chrs = Character.toChars(entityValue22);
                out.write(chrs[0]);
                out.write((int)var1_3[1]);
            } else {
                void var1_2;
                void var3_5;
                var3_5.write((int)var1_2);
            }
            return end + 2 - var2_4 + (isHex ? 1 : 0) + (semiNext ? 1 : 0);
        }
        return 0;
    }

    public static enum OPTION {
        semiColonRequired,
        semiColonOptional,
        errorIfNoSemiColon;

    }
}

