/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.apache.commons.lang3.text.translate;

import com.google.repacked.apache.commons.lang3.text.translate.CodePointTranslator;
import java.io.IOException;
import java.io.Writer;

public class UnicodeEscaper
extends CodePointTranslator {
    private final int below;
    private final int above;
    private final boolean between;

    /*
     * WARNING - void declaration
     */
    protected UnicodeEscaper(int below, int above, boolean between) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.below = var1_1;
        this.above = var2_2;
        this.between = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean translate(int codepoint, Writer out) throws IOException {
        if (this.between ? codepoint < this.below || codepoint > this.above : codepoint >= this.below && codepoint <= this.above) {
            return false;
        }
        if (codepoint > 65535) {
            out.write(this.toUtf16Escape(codepoint));
        } else if (codepoint > 4095) {
            out.write("\\u" + UnicodeEscaper.hex(codepoint));
        } else if (codepoint > 255) {
            out.write("\\u0" + UnicodeEscaper.hex(codepoint));
        } else if (codepoint > 15) {
            out.write("\\u00" + UnicodeEscaper.hex(codepoint));
        } else {
            void var1_1;
            void var2_2;
            var2_2.write("\\u000" + UnicodeEscaper.hex((int)var1_1));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected String toUtf16Escape(int codepoint) {
        void var1_1;
        return "\\u" + UnicodeEscaper.hex((int)var1_1);
    }
}

