/*
 * Decompiled with CFR 0.152.
 */
package org.abego.treelayout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeLayout<TreeNode> {
    private final TreeForTreeLayout<TreeNode> tree;
    private final NodeExtentProvider<TreeNode> nodeExtentProvider;
    private final Configuration<TreeNode> configuration;
    private double boundsLeft = Double.MAX_VALUE;
    private double boundsRight = Double.MIN_VALUE;
    private double boundsTop = Double.MAX_VALUE;
    private double boundsBottom = Double.MIN_VALUE;
    private final List<Double> sizeOfLevel = new ArrayList<Double>();
    private final boolean useIdentity;
    private final Map<TreeNode, Double> mod;
    private final Map<TreeNode, TreeNode> thread;
    private final Map<TreeNode, Double> prelim;
    private final Map<TreeNode, Double> change;
    private final Map<TreeNode, Double> shift;
    private final Map<TreeNode, TreeNode> ancestor;
    private final Map<TreeNode, Integer> number;
    private final Map<TreeNode, Point2D> positions;
    private Map<TreeNode, Rectangle2D.Double> nodeBounds;

    public final TreeForTreeLayout<TreeNode> getTree() {
        return this.tree;
    }

    /*
     * WARNING - void declaration
     */
    private double getNodeHeight(TreeNode node) {
        void var1_1;
        return this.nodeExtentProvider.getHeight(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private double getNodeWidth(TreeNode node) {
        void var1_1;
        return this.nodeExtentProvider.getWidth(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private double getWidthOrHeightOfNode(TreeNode treeNode, boolean returnWidth) {
        void var1_1;
        if (returnWidth) {
            return this.getNodeWidth(treeNode);
        }
        return this.getNodeHeight(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private double getNodeThickness(TreeNode treeNode) {
        void var1_1;
        return this.getWidthOrHeightOfNode(var1_1, !this.isLevelChangeInYAxis());
    }

    /*
     * WARNING - void declaration
     */
    private double getNodeSize(TreeNode treeNode) {
        void var1_1;
        return this.getWidthOrHeightOfNode(var1_1, this.isLevelChangeInYAxis());
    }

    /*
     * WARNING - void declaration
     */
    private boolean isLevelChangeInYAxis() {
        void var1_1;
        Configuration.Location rootLocation = this.configuration.getRootLocation();
        return rootLocation == Configuration.Location.Top || var1_1 == Configuration.Location.Bottom;
    }

    public final Rectangle2D getBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.boundsRight - this.boundsLeft, this.boundsBottom - this.boundsTop);
    }

    /*
     * WARNING - void declaration
     */
    private void calcSizeOfLevels(TreeNode node, int level) {
        void var3_3;
        double oldSize;
        if (this.sizeOfLevel.size() <= level) {
            this.sizeOfLevel.add(0.0);
            oldSize = 0.0;
        } else {
            oldSize = this.sizeOfLevel.get(level);
        }
        double size = this.getNodeThickness(node);
        if (var3_3 < size) {
            this.sizeOfLevel.set(level, size);
        }
        if (!this.tree.isLeaf(node)) {
            for (TreeNode child : this.tree.getChildren(node)) {
                this.calcSizeOfLevels(child, level + 1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private double getMod(TreeNode node) {
        Double d = this.mod.get(node);
        if (d != null) {
            void var1_1;
            return var1_1.doubleValue();
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private void setMod(TreeNode node, double d) {
        void var2_2;
        void var1_1;
        this.mod.put(var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private TreeNode getThread(TreeNode node) {
        TreeNode n = this.thread.get(node);
        if (n != null) {
            void var1_1;
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void setThread(TreeNode node, TreeNode thread) {
        void var2_2;
        void var1_1;
        this.thread.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private double getPrelim(TreeNode node) {
        Double d = this.prelim.get(node);
        if (d != null) {
            void var1_1;
            return var1_1.doubleValue();
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private void setPrelim(TreeNode node, double d) {
        void var2_2;
        void var1_1;
        this.prelim.put(var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private double getChange(TreeNode node) {
        Double d = this.change.get(node);
        if (d != null) {
            void var1_1;
            return var1_1.doubleValue();
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private void setChange(TreeNode node, double d) {
        void var2_2;
        void var1_1;
        this.change.put(var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private double getShift(TreeNode node) {
        Double d = this.shift.get(node);
        if (d != null) {
            void var1_1;
            return var1_1.doubleValue();
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private double getDistance(TreeNode v, TreeNode w) {
        void var2_2;
        void var1_1;
        double d = this.getNodeSize(var1_1) + this.getNodeSize(var2_2);
        double d2 = d / 2.0 + this.configuration.getGapBetweenNodes$2838e59b();
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    private TreeNode nextLeft(TreeNode v) {
        void var1_1;
        if (this.tree.isLeaf(v)) {
            return this.getThread(v);
        }
        return this.tree.getFirstChild(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private TreeNode nextRight(TreeNode v) {
        void var1_1;
        if (this.tree.isLeaf(v)) {
            return this.getThread(v);
        }
        return this.tree.getLastChild(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int getNumber(TreeNode node, TreeNode parentNode) {
        Integer n;
        Integer n2 = this.number.get(node);
        if (n2 == null) {
            void var1_1;
            int i = 1;
            for (TreeNode child : this.tree.getChildren(parentNode)) {
                this.number.put(child, i++);
            }
            n = this.number.get(var1_1);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private void firstWalk(TreeNode v, TreeNode leftSibling) {
        void var1_1;
        if (this.tree.isLeaf(v)) {
            TreeNode w = leftSibling;
            if (w != null) {
                this.setPrelim(v, this.getPrelim(w) + this.getDistance(v, w));
            }
            return;
        }
        Object defaultAncestor = this.tree.getFirstChild(v);
        Double previousChild = null;
        for (TreeNode w : this.tree.getChildren(v)) {
            this.firstWalk(w, previousChild);
            TreeNode TreeNode2 = v;
            Double d = previousChild;
            Object object = defaultAncestor;
            previousChild = (Double)w;
            defaultAncestor = this;
            Double d2 = d;
            if (d2 != null) {
                Iterator<TreeNode> iterator = previousChild;
                TreeNode TreeNode3 = previousChild;
                Double d3 = d2;
                d = (Double)((TreeLayout)defaultAncestor).tree.getFirstChild(TreeNode2);
                d2 = super.getMod(TreeNode3);
                Double d4 = super.getMod(iterator);
                Double d5 = super.getMod(d3);
                Double d6 = super.getMod(d);
                d3 = super.nextRight(d3);
                TreeNode3 = super.nextLeft(TreeNode3);
                while (d3 != null && TreeNode3 != null) {
                    double d7;
                    d = super.nextLeft(d);
                    iterator = super.nextRight(iterator);
                    Double d8 = previousChild;
                    Object object2 = iterator;
                    Object object3 = defaultAncestor;
                    ((TreeLayout)object3).ancestor.put(object2, d8);
                    double d9 = super.getPrelim(d3) + d5 - (super.getPrelim(TreeNode3) + d2) + super.getDistance(d3, TreeNode3);
                    if (d7 > 0.0) {
                        Object object4 = object;
                        d8 = TreeNode2;
                        object2 = d3;
                        object3 = defaultAncestor;
                        Object object5 = object2;
                        Object object6 = object3;
                        Object object7 = ((TreeLayout)object3).ancestor.get(object5);
                        Object object8 = object7 != null ? object7 : object5;
                        Object object9 = ((TreeLayout)object3).tree.isChildOfParent((Double)object8, d8) ? object8 : object4;
                        double d10 = d9;
                        object4 = TreeNode2;
                        d8 = previousChild;
                        object2 = object9;
                        object3 = defaultAncestor;
                        int n = super.getNumber(d8, object4) - super.getNumber(object2, object4);
                        super.setChange(d8, super.getChange(d8) - d10 / (double)n);
                        double d11 = super.getShift(d8) + d10;
                        object7 = d8;
                        object5 = object3;
                        ((TreeLayout)object5).shift.put(object7, d11);
                        super.setChange(object2, super.getChange(object2) + d10 / (double)n);
                        super.setPrelim(d8, super.getPrelim(d8) + d10);
                        super.setMod(d8, super.getMod(d8) + d10);
                        d2 = d2 + d9;
                        d4 = d4 + d9;
                    }
                    d5 = d5 + super.getMod(d3);
                    d2 = d2 + super.getMod(TreeNode3);
                    d6 = d6 + super.getMod(d);
                    d4 = d4 + super.getMod(iterator);
                    d3 = super.nextRight(d3);
                    TreeNode3 = super.nextLeft(TreeNode3);
                }
                if (d3 != null && super.nextRight(iterator) == null) {
                    super.setThread(iterator, d3);
                    super.setMod(iterator, super.getMod(iterator) + d5 - d4);
                }
                if (TreeNode3 != null && super.nextLeft(d) == null) {
                    super.setThread(d, TreeNode3);
                    super.setMod(d, super.getMod(d) + d2 - d6);
                    object = previousChild;
                }
            }
            defaultAncestor = object;
            previousChild = (Double)w;
        }
        TreeNode TreeNode4 = v;
        TreeLayout treeLayout = this;
        double d = 0.0;
        double d12 = 0.0;
        for (TreeNode TreeNode3 : treeLayout.tree.getChildrenReverse(TreeNode4)) {
            treeLayout.setPrelim(TreeNode3, treeLayout.getPrelim(TreeNode3) + d);
            treeLayout.setMod(TreeNode3, treeLayout.getMod(TreeNode3) + d);
            d = d + treeLayout.getShift(TreeNode3) + (d12 += treeLayout.getChange(TreeNode3));
        }
        double midpoint = (this.getPrelim(this.tree.getFirstChild(v)) + this.getPrelim(this.tree.getLastChild(v))) / 2.0;
        TreeNode w = leftSibling;
        if (w != null) {
            void var2_2;
            this.setPrelim(v, this.getPrelim(w) + this.getDistance(v, var2_2));
            this.setMod(v, this.getPrelim(v) - midpoint);
            return;
        }
        this.setPrelim(var1_1, midpoint);
    }

    /*
     * WARNING - void declaration
     */
    private void secondWalk(TreeNode v, double m, int level, double levelStart) {
        void var17_15;
        TreeLayout treeLayout = this;
        Configuration.Location location = treeLayout.configuration.getRootLocation();
        double levelChangeSign = location == Configuration.Location.Bottom || location == Configuration.Location.Right ? -1 : 1;
        boolean levelChangeOnYAxis = this.isLevelChangeInYAxis();
        int n = level;
        treeLayout = this;
        Configuration.checkArg(n >= 0, "level must be >= 0");
        TreeLayout treeLayout2 = treeLayout;
        Configuration.checkArg(n < treeLayout2.sizeOfLevel.size(), "level must be < levelCount");
        double levelSize = treeLayout.sizeOfLevel.get(n);
        double x = this.getPrelim(v) + m;
        Configuration.AlignmentInLevel alignment = this.configuration.getAlignmentInLevel();
        double y = alignment == Configuration.AlignmentInLevel.Center ? levelStart + levelChangeSign * (levelSize / 2.0) : (var17_15 == Configuration.AlignmentInLevel.TowardsRoot ? levelStart + levelChangeSign * (this.getNodeThickness(v) / 2.0) : levelStart + levelSize - levelChangeSign * (this.getNodeThickness(v) / 2.0));
        if (!levelChangeOnYAxis) {
            double t = x;
            x = y;
            y = t;
        }
        this.positions.put(v, new NormalizedPosition(this, x, y));
        double d = y;
        double d2 = x;
        TreeNode TreeNode2 = v;
        treeLayout = this;
        double d3 = treeLayout.getNodeWidth(TreeNode2);
        double d4 = treeLayout.getNodeHeight(TreeNode2);
        double d5 = d2 - d3 / 2.0;
        double d6 = d2 + d3 / 2.0;
        double d7 = d - d4 / 2.0;
        double d8 = d + d4 / 2.0;
        if (treeLayout.boundsLeft > d5) {
            treeLayout.boundsLeft = d5;
        }
        if (treeLayout.boundsRight < d6) {
            treeLayout.boundsRight = d6;
        }
        if (treeLayout.boundsTop > d7) {
            treeLayout.boundsTop = d7;
        }
        if (treeLayout.boundsBottom < d8) {
            treeLayout.boundsBottom = d8;
        }
        if (!this.tree.isLeaf(v)) {
            double nextLevelStart = levelStart + (levelSize + this.configuration.getGapBetweenLevels$13461c()) * levelChangeSign;
            for (TreeNode w : this.tree.getChildren(v)) {
                this.secondWalk(w, m + this.getMod(v), level + 1, nextLevelStart);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Map<TreeNode, Rectangle2D.Double> getNodeBounds() {
        if (this.nodeBounds == null) {
            this.nodeBounds = this.useIdentity ? new IdentityHashMap() : new HashMap();
            for (Map.Entry<TreeNode, Point2D> entry : this.positions.entrySet()) {
                void var3_3;
                void var2_2;
                TreeNode node = entry.getKey();
                Point2D pos = entry.getValue();
                double w = this.getNodeWidth(node);
                double h = this.getNodeHeight(node);
                double x = pos.getX() - w / 2.0;
                double y = var2_2.getY() - h / 2.0;
                this.nodeBounds.put(var3_3, new Rectangle2D.Double(x, y, w, h));
            }
        }
        return this.nodeBounds;
    }

    /*
     * WARNING - void declaration
     */
    public TreeLayout(TreeForTreeLayout<TreeNode> tree, NodeExtentProvider<TreeNode> nodeExtentProvider, Configuration<TreeNode> configuration, boolean useIdentity) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.tree = tree;
        this.nodeExtentProvider = var2_2;
        this.configuration = var3_3;
        this.useIdentity = true;
        if (this.useIdentity) {
            this.mod = new IdentityHashMap<TreeNode, Double>();
            this.thread = new IdentityHashMap<TreeNode, TreeNode>();
            this.prelim = new IdentityHashMap<TreeNode, Double>();
            this.change = new IdentityHashMap<TreeNode, Double>();
            this.shift = new IdentityHashMap<TreeNode, Double>();
            this.ancestor = new IdentityHashMap<TreeNode, TreeNode>();
            this.number = new IdentityHashMap<TreeNode, Integer>();
            this.positions = new IdentityHashMap<TreeNode, Point2D>();
        } else {
            this.mod = new HashMap<TreeNode, Double>();
            this.thread = new HashMap<TreeNode, TreeNode>();
            this.prelim = new HashMap<TreeNode, Double>();
            this.change = new HashMap<TreeNode, Double>();
            this.shift = new HashMap<TreeNode, Double>();
            this.ancestor = new HashMap<TreeNode, TreeNode>();
            this.number = new HashMap<TreeNode, Integer>();
            this.positions = new HashMap<TreeNode, Point2D>();
        }
        TreeNode r = tree.getRoot();
        this.firstWalk(r, null);
        this.calcSizeOfLevels(r, 0);
        this.secondWalk(r, -this.getPrelim(var1_1), 0, 0.0);
    }

    final class NormalizedPosition
    extends Point2D {
        private double x_relativeToRoot;
        private double y_relativeToRoot;
        private /* synthetic */ TreeLayout this$0;

        /*
         * WARNING - void declaration
         */
        public NormalizedPosition(TreeLayout treeLayout, double x_relativeToRoot, double y_relativeToRoot) {
            void var2_2;
            this.this$0 = treeLayout;
            this.setLocation((double)var2_2, y_relativeToRoot);
        }

        public final double getX() {
            return this.x_relativeToRoot - this.this$0.boundsLeft;
        }

        public final double getY() {
            return this.y_relativeToRoot - this.this$0.boundsTop;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLocation(double x_relativeToRoot, double y_relativeToRoot) {
            void var3_2;
            void var1_1;
            this.x_relativeToRoot = var1_1;
            this.y_relativeToRoot = var3_2;
        }
    }
}

