/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

public final class HebrewProber
extends CharsetProber {
    private int finalCharLogicalScore;
    private int finalCharVisualScore;
    private byte prev;
    private byte beforePrev;
    private CharsetProber logicalProber = null;
    private CharsetProber visualProber = null;

    public HebrewProber() {
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    public final void setModalProbers(CharsetProber logicalProber, CharsetProber visualProber) {
        void var2_2;
        void var1_1;
        this.logicalProber = var1_1;
        this.visualProber = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final String getCharSetName() {
        void var1_1;
        void var2_2;
        float f;
        int finalsub = this.finalCharLogicalScore - this.finalCharVisualScore;
        if (finalsub >= 5) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (finalsub <= -5) {
            return Constants.CHARSET_ISO_8859_8;
        }
        float modelsub = this.logicalProber.getConfidence() - this.visualProber.getConfidence();
        if (f > 0.01f) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (var2_2 < -0.01f) {
            return Constants.CHARSET_ISO_8859_8;
        }
        if (var1_1 < 0) {
            return Constants.CHARSET_ISO_8859_8;
        }
        return Constants.CHARSET_WINDOWS_1255;
    }

    public final float getConfidence() {
        return 0.0f;
    }

    public final CharsetProber.ProbingState getState() {
        if (this.logicalProber.getState() == CharsetProber.ProbingState.NOT_ME && this.visualProber.getState() == CharsetProber.ProbingState.NOT_ME) {
            return CharsetProber.ProbingState.NOT_ME;
        }
        return CharsetProber.ProbingState.DETECTING;
    }

    /*
     * WARNING - void declaration
     */
    public final CharsetProber.ProbingState handleData(byte[] buf, int offset, int length) {
        if (this.getState() == CharsetProber.ProbingState.NOT_ME) {
            return CharsetProber.ProbingState.NOT_ME;
        }
        int maxPos = offset + length;
        for (int i = offset; i < maxPos; ++i) {
            void var2_2;
            byte c = buf[i];
            if (c == 32) {
                if (this.beforePrev != 32) {
                    if (HebrewProber.isFinal(this.prev)) {
                        ++this.finalCharLogicalScore;
                    } else {
                        int n = this.prev;
                        if ((n &= 0xFF) == 235 || n == 238 || n == 240 || n == 244) {
                            ++this.finalCharVisualScore;
                        }
                    }
                }
            } else if (this.beforePrev == 32 && HebrewProber.isFinal(this.prev) && c != 32) {
                ++this.finalCharVisualScore;
            }
            this.beforePrev = this.prev;
            this.prev = var2_2;
        }
        return CharsetProber.ProbingState.DETECTING;
    }

    public final void reset() {
        this.finalCharLogicalScore = 0;
        this.finalCharVisualScore = 0;
        this.prev = (byte)32;
        this.beforePrev = (byte)32;
    }

    private static boolean isFinal(byte b) {
        byte by;
        int n = b & 0xFF;
        byte c = (byte)n;
        return n == 234 || c == 237 || c == 239 || c == 243 || by == 245;
    }
}

