/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober.distributionanalysis;

public abstract class CharDistributionAnalysis {
    private int freqChars;
    private int totalChars;
    protected int[] charToFreqOrder;
    protected float typicalDistributionRatio;

    public CharDistributionAnalysis() {
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    public final void handleOneChar(byte[] buf, int offset, int charLength) {
        void var3_3;
        int order = -1;
        if (var3_3 == 2) {
            void var2_2;
            void var1_1;
            order = this.getOrder((byte[])var1_1, (int)var2_2);
        }
        if (order >= 0) {
            ++this.totalChars;
            if (order < this.charToFreqOrder.length && 512 > this.charToFreqOrder[order]) {
                ++this.freqChars;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float getConfidence() {
        if (this.totalChars <= 0 || this.freqChars <= 4) {
            return 0.01f;
        }
        if (this.totalChars != this.freqChars) {
            float f;
            float r = (float)(this.freqChars / (this.totalChars - this.freqChars)) * this.typicalDistributionRatio;
            if (f < 0.99f) {
                void var1_1;
                return (float)var1_1;
            }
        }
        return 0.99f;
    }

    public final void reset() {
        this.totalChars = 0;
        this.freqChars = 0;
    }

    public final boolean gotEnoughData() {
        return this.totalChars > 1024;
    }

    protected abstract int getOrder(byte[] var1, int var2);
}

