/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common.converter;

import com.applitools.eyes.android.common.converter.JacksonRequestBodyConverter;
import com.applitools.eyes.android.common.converter.JacksonResponseBodyConverter;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class JacksonConverterFactory
extends Converter.Factory {
    private final ObjectMapper mapper;

    public static JacksonConverterFactory create() {
        return JacksonConverterFactory.create(new ObjectMapper());
    }

    public static JacksonConverterFactory create(ObjectMapper mapper) {
        return new JacksonConverterFactory(mapper);
    }

    private JacksonConverterFactory(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        this.mapper = mapper;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private boolean hasJsonRootName(JavaType valueType) {
        if (valueType.getRawClass() == null) {
            return false;
        }
        JsonRootName rootAnnotation = valueType.getRawClass().getAnnotation(JsonRootName.class);
        return rootAnnotation != null;
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.reader(javaType);
        return new JacksonResponseBodyConverter(reader);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        this.mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, this.hasJsonRootName(javaType));
        ObjectWriter writer = this.mapper.writerWithType(javaType);
        return new JacksonRequestBodyConverter(writer);
    }
}

