/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"$id", "isPassed"})
public class TestResults {
    private int steps;
    private int matches;
    private int mismatches;
    private int missing;
    private int exactMatches;
    private int strictMatches;
    private int contentMatches;
    private int layoutMatches;
    private int noneMatches;
    private String url;
    private boolean isNew;
    @JsonProperty(value="isDifferent")
    private boolean isDifferent;
    @JsonProperty(value="isAborted")
    private boolean isAborted;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="appName")
    private String appName;

    public int getSteps() {
        return this.steps;
    }

    public int getMatches() {
        return this.matches;
    }

    public int getMismatches() {
        return this.mismatches;
    }

    public int getMissing() {
        return this.missing;
    }

    public int getExactMatches() {
        return this.exactMatches;
    }

    public int getStrictMatches() {
        return this.strictMatches;
    }

    public int getContentMatches() {
        return this.contentMatches;
    }

    public int getLayoutMatches() {
        return this.layoutMatches;
    }

    public int getNoneMatches() {
        return this.noneMatches;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isPassed() {
        return !this.isNew() && this.getMismatches() == 0 && this.getMissing() == 0;
    }

    void setSteps(int steps) {
        ArgumentGuard.greaterThanOrEqualToZero(steps, "steps");
        this.steps = steps;
    }

    void setMatches(int matches) {
        ArgumentGuard.greaterThanOrEqualToZero(matches, "matches");
        this.matches = matches;
    }

    void setMismatches(int mismatches) {
        ArgumentGuard.greaterThanOrEqualToZero(mismatches, "mismatches");
        this.mismatches = mismatches;
    }

    void setMissing(int missing) {
        ArgumentGuard.greaterThanOrEqualToZero(missing, "missing");
        this.missing = missing;
    }

    void setExactMatches(int exactMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(exactMatches, "exactMatches");
        this.exactMatches = exactMatches;
    }

    void setStrictMatches(int strictMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(strictMatches, "strictMatches");
        this.strictMatches = strictMatches;
    }

    void setContentMatches(int contentMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(contentMatches, "contentMatches");
        this.contentMatches = contentMatches;
    }

    void setLayoutMatches(int layoutMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(layoutMatches, "layoutMatches");
        this.layoutMatches = layoutMatches;
    }

    void setNoneMatches(int noneMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(noneMatches, "noneMatches");
        this.noneMatches = noneMatches;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isDifferent() {
        return this.isDifferent;
    }

    public void setDifferent(boolean isDifferent) {
        this.isDifferent = isDifferent;
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public void setAborted(boolean isAborted) {
        this.isAborted = isAborted;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String toString() {
        String isNewTestStr = this.isNew ? "New test" : "Existing test";
        return isNewTestStr + " [ steps: " + this.getSteps() + ", matches: " + this.getMatches() + ", mismatches:" + this.getMismatches() + ", missing: " + this.getMissing() + "] , URL: " + this.getUrl();
    }
}

