/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common.logger;

import com.applitools.eyes.android.common.logger.LogHandler;
import com.applitools.eyes.android.common.logger.NullLogHandler;
import com.applitools.eyes.android.common.utils.ArgumentGuard;

public class Logger {
    public static final String LOGGER_NAME = "EyesLog";
    private LogHandler mLogHandler = new NullLogHandler();

    public LogHandler getLogHandler() {
        return this.mLogHandler;
    }

    public void setLogHandler(LogHandler handler) {
        ArgumentGuard.notNull(handler, "handler");
        this.mLogHandler = handler;
    }

    private String getPrefix() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String prefix = "";
        if (stackTraceElements != null && stackTraceElements.length >= 4) {
            prefix = stackTraceElements[3].getMethodName() + "():";
        }
        return prefix;
    }

    public void verbose(String message) {
        this.mLogHandler.onMessage(true, this.getPrefix() + message);
    }

    public void log(String message) {
        this.mLogHandler.onMessage(false, this.getPrefix() + message);
    }
}

