/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common.network;

import com.applitools.eyes.android.common.MatchData;
import com.applitools.eyes.android.common.MatchResult;
import com.applitools.eyes.android.common.RunningSession;
import com.applitools.eyes.android.common.SessionStartInfo;
import com.applitools.eyes.android.common.TestResults;
import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.network.MatchService;
import com.applitools.eyes.android.common.network.ServiceGenerator;
import com.applitools.eyes.android.common.network.SessionService;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.common.utils.GeneralUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.TimeZone;
import retrofit2.Call;
import retrofit2.Response;

public class RestClient {
    private String mApiKey;
    private URI mServerUrl;

    RestClient(URI serverUrl) {
        this.mServerUrl = serverUrl;
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull(apiKey, "apiKey");
        this.mApiKey = apiKey;
    }

    public void setServerUrl(URI serverUrl) {
        this.mServerUrl = serverUrl;
    }

    public URI getServerUrl() {
        return this.mServerUrl;
    }

    public String getApiKey() {
        return this.mApiKey;
    }

    public RunningSession startSession(final SessionStartInfo sessionStartInfo) throws EyesException {
        ArgumentGuard.notNull(sessionStartInfo, "sessionStartInfo");
        final RunningSession[] result = new RunningSession[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SessionService sessionService = ServiceGenerator.createService(RestClient.this.mServerUrl.toString(), SessionService.class);
                Call<RunningSession> call = sessionService.startSession(RestClient.this.getApiKey(), sessionStartInfo);
                try {
                    Response response = call.execute();
                    if (!response.isSuccessful()) {
                        throw new EyesException(response.message());
                    }
                    ((RunningSession)response.body()).setIsNewSession(response.code() == 201);
                    result[0] = (RunningSession)response.body();
                }
                catch (IOException e) {
                    throw new EyesException("Failed to connect to server ", e);
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new EyesException("", e);
        }
        return result[0];
    }

    public TestResults stopSession(final RunningSession runningSession, final boolean isAborted, final boolean save) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        final TestResults[] result = new TestResults[]{null};
        final String currentTime = GeneralUtils.toRfc1123(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SessionService sessionService = ServiceGenerator.createService(RestClient.this.mServerUrl.toString(), SessionService.class);
                Call<TestResults> call = sessionService.stopSession(currentTime, runningSession.getId(), RestClient.this.getApiKey(), String.valueOf(isAborted), String.valueOf(save));
                try {
                    Response response = call.execute();
                    result[0] = (TestResults)response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    public MatchResult matchWindow(final RunningSession runningSession, final MatchData matchData) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(matchData, "data");
        final MatchResult[] result = new MatchResult[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MatchService matchService = ServiceGenerator.createService(RestClient.this.mServerUrl.toString(), MatchService.class);
                Call<MatchResult> call = matchService.matchWindow(runningSession.getId(), RestClient.this.getApiKey(), matchData);
                try {
                    Response response = call.execute();
                    result[0] = (MatchResult)response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }
}

