package com.applitools.eyes.android.common;

import com.applitools.eyes.android.common.utils.ArgumentGuard;

/**
 * Base class for handling screenshots.
 */
public abstract class EyesScreenshot {
    protected String mImage;

    public EyesScreenshot(String image) {
        ArgumentGuard.notNull(image, "image");
        this.mImage = image;
    }

    /**
     * @return The screenshot image.
     */
    public String getImage() {
        return mImage;
    }

    /**
     * Returns a part of the screenshot based on the given region.
     *
     * @param region          The region for which we should get the sub screenshot.
     * @return A screenshot instance containing the given region.
     */
    public abstract EyesScreenshot getSubScreenshot(Region region);
}
