package com.applitools.eyes.android.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The result of a window match by the agent.
 */
@JsonIgnoreProperties({"$id", "screenshot"})
public class MatchResult {

    @JsonProperty("AsExpected")
    private boolean asExpected;
    private String windowId;
    private EyesScreenshot screenshot;

    public MatchResult() {}

    public boolean getAsExpected() {
        return asExpected;
    }

    public void setAsExpected(boolean asExpected) {
        this.asExpected = asExpected;
    }

    public EyesScreenshot getScreenshot() {
        return screenshot;
    }
}
