package com.applitools.eyes.android.common;

import com.applitools.eyes.android.common.utils.ArgumentGuard;

public class Region {

    public static final int FULL_WIDTH = 0;

    private int mWidth;
    private int mHeight;
    private int mTop;
    private int mLeft;

    public static final Region EMPTY = new Region(0, 0, 0, 0);

    void makeEmpty() {
        mLeft = EMPTY.getLeft();
        mTop = EMPTY.getTop();
        mWidth = EMPTY.getWidth();
        mHeight = EMPTY.getHeight();
    }

    private Region() {

    }

    public Region(Region other) {
        ArgumentGuard.notNull(other, "other");

        mLeft = other.getLeft();
        mTop = other.getTop();
        mWidth = other.getWidth();
        mHeight = other.getHeight();
    }

    public Region(int width, int height, int top, int left) {
        ArgumentGuard.greaterThanOrEqualToZero(width, "width");
        ArgumentGuard.greaterThanOrEqualToZero(height, "height");

        mWidth = width;
        mHeight = height;
        mTop = top;
        mLeft = left;
    }

    /**
     *
     * @return true if the region is empty, false otherwise.
     */
    public boolean isEmpty() {
        return this.getLeft() == EMPTY.getLeft()
                && this.getTop() == EMPTY .getTop()
                && this.getWidth() == EMPTY.getWidth()
                && this.getHeight() == EMPTY.getHeight();
    }

    public int getWidth() {
        return mWidth;
    }

    public int getHeight() {
        return mHeight;
    }

    public int getTop() {
        return mTop;
    }

    public int getLeft() {
        return mLeft;
    }
}
