package com.applitools.eyes.android.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Encapsulates data for the session currently running in the agent.
 */
@JsonIgnoreProperties(value = {"isNewSession", "$id", "steps"}, ignoreUnknown = true)
public class RunningSession {

    private boolean isNewSession;

    @JsonProperty(value = "Id")
    private String id;

    @JsonProperty(value = "Url")
    private String url;

    public RunningSession() {
        isNewSession = false;
    }


    public boolean getIsNewSession() {
        return isNewSession;
    }

    public void setIsNewSession(boolean isNewSession) {
        this.isNewSession = isNewSession;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
