/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import com.applitools.eyes.android.common.utils.ArgumentGuard;

public class Region {
    public static final int FULL_WIDTH = 0;
    private int mWidth;
    private int mHeight;
    private int mTop;
    private int mLeft;
    public static final Region EMPTY = new Region(0, 0, 0, 0);

    void makeEmpty() {
        this.mLeft = EMPTY.getLeft();
        this.mTop = EMPTY.getTop();
        this.mWidth = EMPTY.getWidth();
        this.mHeight = EMPTY.getHeight();
    }

    private Region() {
    }

    public Region(Region other) {
        ArgumentGuard.notNull(other, "other");
        this.mLeft = other.getLeft();
        this.mTop = other.getTop();
        this.mWidth = other.getWidth();
        this.mHeight = other.getHeight();
    }

    public Region(int width, int height, int top, int left) {
        ArgumentGuard.greaterThanOrEqualToZero(width, "width");
        ArgumentGuard.greaterThanOrEqualToZero(height, "height");
        this.mWidth = width;
        this.mHeight = height;
        this.mTop = top;
        this.mLeft = left;
    }

    public boolean isEmpty() {
        return this.getLeft() == EMPTY.getLeft() && this.getTop() == EMPTY.getTop() && this.getWidth() == EMPTY.getWidth() && this.getHeight() == EMPTY.getHeight();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getLeft() {
        return this.mLeft;
    }
}

