/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common.network;

import com.applitools.eyes.android.common.AbstractProxySettings;
import com.applitools.eyes.android.common.MatchData;
import com.applitools.eyes.android.common.MatchResult;
import com.applitools.eyes.android.common.MatchWindowData;
import com.applitools.eyes.android.common.RunningSession;
import com.applitools.eyes.android.common.SessionStartInfo;
import com.applitools.eyes.android.common.SessionStartInfoBody;
import com.applitools.eyes.android.common.TestResults;
import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.network.ResponseObject;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.common.utils.GeneralUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.TimeZone;

public class RestClient {
    private String mApiKey;
    private URI mServerUrl;
    private ObjectMapper mObjectMapper;
    private AbstractProxySettings mProxySettings = null;

    RestClient(URI serverUrl) {
        this.mServerUrl = serverUrl;
        this.mObjectMapper = new ObjectMapper();
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull(apiKey, "apiKey");
        this.mApiKey = apiKey;
    }

    public void setProxySettings(AbstractProxySettings proxySettings) {
        this.mProxySettings = proxySettings;
    }

    public void setServerUrl(URI serverUrl) {
        this.mServerUrl = serverUrl;
    }

    public URI getServerUrl() {
        return this.mServerUrl;
    }

    public String getApiKey() {
        return this.mApiKey != null ? this.mApiKey : System.getenv("APPLITOOLS_API_KEY");
    }

    public RunningSession startSession(final SessionStartInfo sessionStartInfo) throws EyesException {
        ArgumentGuard.notNull(sessionStartInfo, "sessionStartInfo");
        final RunningSession[] result = new RunningSession[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = RestClient.this.mServerUrl.toString() + "/api/sessions/running" + "?apiKey=" + RestClient.this.getApiKey();
                    SessionStartInfoBody body = new SessionStartInfoBody(sessionStartInfo);
                    ResponseObject responseObject = RestClient.this.makePOSTRequest(url, RestClient.this.mObjectMapper.writeValueAsString((Object)body), RestClient.this.getApiKey());
                    if (responseObject.getCode() == 401) {
                        throw new EyesException("Failed to connect to server. Please check your APPLITOOLS_API_KEY");
                    }
                    RunningSession runningSession = (RunningSession)RestClient.this.mObjectMapper.readValue(responseObject.getMessage(), RunningSession.class);
                    if (!responseObject.isSuccessful()) {
                        throw new EyesException(responseObject.getMessage());
                    }
                    runningSession.setIsNewSession(responseObject.getCode() == 201);
                    result[0] = runningSession;
                }
                catch (IOException e) {
                    throw new EyesException("Failed to connect to server ", e);
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new EyesException("", e);
        }
        return result[0];
    }

    public TestResults stopSession(final RunningSession runningSession, final boolean isAborted, final boolean save) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        final TestResults[] result = new TestResults[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = RestClient.this.mServerUrl.toString() + "/api/sessions/running/{session_id}".replace("{session_id}", runningSession.getId()) + "?apiKey=" + RestClient.this.getApiKey() + "&aborted=" + String.valueOf(isAborted) + "&updateBaseline=" + String.valueOf(save);
                    ResponseObject responseObject = RestClient.this.makeDELETERequest(url);
                    result[0] = (TestResults)RestClient.this.mObjectMapper.readValue(responseObject.getMessage(), TestResults.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    public MatchResult matchWindow(final RunningSession runningSession, final MatchData matchData) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(matchData, "data");
        final MatchResult[] result = new MatchResult[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = RestClient.this.mServerUrl.toString() + "/api/sessions/running/{session_id}".replace("{session_id}", runningSession.getId()) + "?apiKey=" + RestClient.this.getApiKey();
                    ResponseObject responseObject = RestClient.this.makePOSTRequest(url, RestClient.this.mObjectMapper.writeValueAsString((Object)matchData), null);
                    result[0] = (MatchResult)RestClient.this.mObjectMapper.readValue(responseObject.getMessage(), MatchResult.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    public MatchResult matchWindow(final RunningSession runningSession, final MatchWindowData matchWindowData) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(matchWindowData, "data");
        final MatchResult[] result = new MatchResult[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = RestClient.this.mServerUrl.toString() + "/api/sessions/running/{session_id}".replace("{session_id}", runningSession.getId()) + "?apiKey=" + RestClient.this.getApiKey();
                    ResponseObject responseObject = RestClient.this.makePOSTRequest(url, RestClient.this.mObjectMapper.writeValueAsString((Object)matchWindowData), null);
                    result[0] = (MatchResult)RestClient.this.mObjectMapper.readValue(responseObject.getMessage(), MatchResult.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObject makePOSTRequest(String url, String requestBody, String apiKey) throws IOException {
        HttpURLConnection conn = this.getConnection(url);
        int responseCode = 0;
        StringBuilder response = new StringBuilder();
        try {
            String line;
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.connect();
            System.out.println("\nSending 'POST' request to URL : " + url);
            System.out.println("Post body : " + requestBody);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            out.writeBytes(requestBody);
            out.flush();
            out.close();
            responseCode = conn.getResponseCode();
            System.out.println("Response Code : " + responseCode);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            System.out.println("Response Body : " + response.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            conn.disconnect();
        }
        return new ResponseObject(responseCode, response.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObject makeDELETERequest(String url) throws IOException {
        int responseCode;
        HttpURLConnection conn = this.getConnection(url);
        StringBuilder response = new StringBuilder();
        try {
            String inputLine;
            conn.setRequestMethod("DELETE");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Eyes-Expect", "202-accepted");
            String currentTime = GeneralUtils.toRfc1123(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            conn.setRequestProperty("Eyes-Date", currentTime);
            conn.setUseCaches(false);
            conn.connect();
            responseCode = conn.getResponseCode();
            System.out.println("\nSending 'DELETE' request to URL : " + url);
            System.out.println("Response Code : " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            System.out.println("Response Body : " + response.toString());
        }
        finally {
            conn.disconnect();
        }
        return new ResponseObject(responseCode, response.toString());
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn;
        URL obj = new URL(url);
        if (this.mProxySettings != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.mProxySettings.getIp(), this.mProxySettings.getPort()));
            if (this.mProxySettings.getUsername() != null && this.mProxySettings.getPassword() != null) {
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(RestClient.this.mProxySettings.getUsername(), RestClient.this.mProxySettings.getPassword().toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
            conn = (HttpURLConnection)obj.openConnection(proxy);
        } else {
            conn = (HttpURLConnection)obj.openConnection();
        }
        return conn;
    }
}

