/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import com.applitools.eyes.android.common.IBatchCloser;
import com.applitools.eyes.android.common.TestResults;
import com.applitools.eyes.android.common.TestResultsSummary;
import com.applitools.eyes.android.common.logger.LogHandler;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.common.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class EyesRunner {
    protected Logger logger = new Logger();
    protected List<TestResults> allTestResult = new ArrayList<TestResults>();
    private Map<String, IBatchCloser> batchesServerConnectorsMap = new HashMap<String, IBatchCloser>();

    public abstract TestResultsSummary getAllTestResultsImpl();

    public abstract TestResultsSummary getAllTestResultsImpl(boolean var1);

    public TestResultsSummary getAllTestResults() {
        return this.getAllTestResults(true);
    }

    public TestResultsSummary getAllTestResults(boolean shouldThrowException) {
        TestResultsSummary allTestResults;
        try {
            allTestResults = this.getAllTestResultsImpl(shouldThrowException);
        }
        finally {
            this.deleteAllBatches();
        }
        return allTestResults;
    }

    private void deleteAllBatches() {
        for (String batch : this.batchesServerConnectorsMap.keySet()) {
            IBatchCloser connector = this.batchesServerConnectorsMap.get(batch);
            try {
                connector.closeBatch(batch);
            }
            catch (Throwable e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
        if (!logHandler.isOpen()) {
            logHandler.open();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addBatch(String batchId, IBatchCloser batchCloser) {
        if (!this.batchesServerConnectorsMap.containsKey(batchId)) {
            this.batchesServerConnectorsMap.put(batchId, batchCloser);
        }
    }

    public void aggregateResult(TestResults testResult) {
        this.allTestResult.add(testResult);
    }
}

