/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import com.applitools.eyes.android.common.AccessibilityRegionByRectangle;
import com.applitools.eyes.android.common.AccessibilitySettings;
import com.applitools.eyes.android.common.ExactMatchSettings;
import com.applitools.eyes.android.common.FloatingMatchSettings;
import com.applitools.eyes.android.common.MatchLevel;
import com.applitools.eyes.android.common.Region;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ImageMatchSettings {
    private Boolean ignoreCaret;
    private boolean ignoreDisplacements = false;
    private MatchLevel matchLevel;
    private ExactMatchSettings exact;
    private Region[] ignoreRegions;
    private Region[] layoutRegions;
    private Region[] strictRegions;
    private Region[] contentRegions;
    private FloatingMatchSettings[] floatingMatchSettings;
    private AccessibilityRegionByRectangle[] accessibility = new AccessibilityRegionByRectangle[0];
    private AccessibilitySettings accessibilitySettings = null;
    public boolean enablePatterns;

    public ImageMatchSettings(MatchLevel matchLevel, ExactMatchSettings exact) {
        this.matchLevel = matchLevel;
        this.exact = exact;
        this.ignoreCaret = true;
    }

    public ImageMatchSettings() {
        this(MatchLevel.STRICT, null);
    }

    public ImageMatchSettings(ImageMatchSettings other) {
        if (other != null) {
            this.matchLevel = other.matchLevel;
            this.exact = other.exact == null ? null : new ExactMatchSettings(other.exact);
            this.ignoreCaret = other.ignoreCaret;
            this.ignoreRegions = other.ignoreRegions;
            this.layoutRegions = other.layoutRegions;
            this.strictRegions = other.strictRegions;
            this.contentRegions = other.contentRegions;
            this.floatingMatchSettings = other.floatingMatchSettings;
            this.enablePatterns = other.enablePatterns;
            this.ignoreDisplacements = other.ignoreDisplacements;
            this.accessibility = other.accessibility;
            this.accessibilitySettings = other.accessibilitySettings;
        } else {
            this.matchLevel = MatchLevel.STRICT;
        }
    }

    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.matchLevel = matchLevel;
    }

    public ExactMatchSettings getExact() {
        return this.exact;
    }

    public void setExact(ExactMatchSettings exact) {
        this.exact = exact;
    }

    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    public void setIgnoreCaret(Boolean ignoreCaret) {
        this.ignoreCaret = ignoreCaret;
    }

    public boolean getIgnoreDisplacements() {
        return this.ignoreDisplacements;
    }

    public void setIgnoreDisplacements(boolean ignoreDisplacements) {
        this.ignoreDisplacements = ignoreDisplacements;
    }

    @JsonSetter(value="Ignore")
    public void setIgnoreRegions(Region[] ignoreRegions) {
        this.ignoreRegions = ignoreRegions;
    }

    @JsonGetter(value="Ignore")
    public Region[] getIgnoreRegions() {
        return this.ignoreRegions;
    }

    @JsonSetter(value="Layout")
    public void setLayoutRegions(Region[] layoutRegions) {
        this.layoutRegions = layoutRegions;
    }

    @JsonGetter(value="Layout")
    public Region[] getLayoutRegions() {
        return this.layoutRegions;
    }

    @JsonSetter(value="Strict")
    public void setStrictRegions(Region[] strictRegions) {
        this.strictRegions = strictRegions;
    }

    @JsonGetter(value="Strict")
    public Region[] getStrictRegions() {
        return this.strictRegions;
    }

    @JsonSetter(value="Content")
    public void setContentRegions(Region[] contentRegions) {
        this.contentRegions = contentRegions;
    }

    @JsonGetter(value="Content")
    public Region[] getContentRegions() {
        return this.contentRegions;
    }

    @JsonSetter(value="Floating")
    public void setFloatingRegions(FloatingMatchSettings[] floatingRegions) {
        this.floatingMatchSettings = floatingRegions;
    }

    @JsonGetter(value="Floating")
    public FloatingMatchSettings[] getFloatingRegions() {
        return this.floatingMatchSettings;
    }

    public String toString() {
        return String.format("Match level: %s, Exact match settings: %s", new Object[]{this.matchLevel, this.exact});
    }

    public void setAccessibility(AccessibilityRegionByRectangle[] accessibilityValidation) {
        this.accessibility = accessibilityValidation;
    }

    public AccessibilitySettings getAccessibilitySettings() {
        return this.accessibilitySettings;
    }

    public void setAccessibilitySettings(AccessibilitySettings accessibilitySettings) {
        this.accessibilitySettings = accessibilitySettings;
    }

    public AccessibilityRegionByRectangle[] getAccessibility() {
        return this.accessibility;
    }

    public boolean isEnablePatterns() {
        return this.enablePatterns;
    }

    public void setEnablePatterns(boolean enablePatterns) {
        this.enablePatterns = enablePatterns;
    }
}

