/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common.network;

import com.applitools.eyes.android.common.AbstractProxySettings;
import com.applitools.eyes.android.common.AppOutput;
import com.applitools.eyes.android.common.MatchData;
import com.applitools.eyes.android.common.MatchResult;
import com.applitools.eyes.android.common.MatchWindowData;
import com.applitools.eyes.android.common.RenderingInfo;
import com.applitools.eyes.android.common.RunningSession;
import com.applitools.eyes.android.common.SessionStartInfo;
import com.applitools.eyes.android.common.SessionStartInfoBody;
import com.applitools.eyes.android.common.TestResults;
import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.common.network.ResponseObject;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.common.utils.GeneralUtils;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public class RestClient {
    private String mApiKey;
    private URI mServerUrl;
    private ObjectMapper mObjectMapper;
    private Logger mLogger;
    private String mAgentId;
    private AbstractProxySettings mProxySettings = null;
    private static final int MAX_RETRY_COUNT = 3;
    private RenderingInfo mRenderingInfo = null;
    private static final int LONG_REQUEST_DELAY_MS = 2000;
    private static final int MAX_LONG_REQUEST_DELAY_MS = 10000;
    private static final double LONG_REQUEST_DELAY_MULTIPLICATIVE_INCREASE_FACTOR = 1.5;

    public RestClient(URI serverUrl, Logger logger) {
        this.mServerUrl = serverUrl;
        this.mObjectMapper = new ObjectMapper();
        this.mObjectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        this.mObjectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true);
        this.mLogger = logger;
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull(apiKey, "apiKey");
        this.mApiKey = apiKey;
    }

    public void setAgentId(String agentId) {
        this.mAgentId = agentId;
    }

    public void setProxySettings(AbstractProxySettings proxySettings) {
        this.mProxySettings = proxySettings;
    }

    public void setServerUrl(URI serverUrl) {
        this.mServerUrl = serverUrl;
    }

    public URI getServerUrl() {
        return this.mServerUrl;
    }

    public String getApiKey() {
        return this.mApiKey != null ? this.mApiKey : GeneralUtils.getEnvString("APPLITOOLS_API_KEY");
    }

    public RunningSession startSession(final SessionStartInfo sessionStartInfo) throws EyesException {
        ArgumentGuard.notNull(sessionStartInfo, "sessionStartInfo");
        final RunningSession[] result = new RunningSession[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = RestClient.this.mServerUrl.toString() + "/api/sessions/running" + "?apiKey=" + RestClient.this.getApiKey();
                    SessionStartInfoBody body = new SessionStartInfoBody(sessionStartInfo);
                    ResponseObject responseObject = RestClient.this.makeRequest(url, RestClient.this.mObjectMapper.writeValueAsString((Object)body), "POST");
                    if (responseObject.getCode() == 401) {
                        throw new EyesException("Failed to connect to server. Please check your APPLITOOLS_API_KEY");
                    }
                    RunningSession runningSession = (RunningSession)RestClient.this.mObjectMapper.readValue(responseObject.getMessage(), RunningSession.class);
                    if (!responseObject.isSuccessful()) {
                        throw new EyesException(responseObject.getMessage());
                    }
                    runningSession.setIsNewSession(runningSession.getIsNew() != null ? runningSession.getIsNew() : responseObject.getCode() == 201);
                    result[0] = runningSession;
                }
                catch (IOException | InterruptedException e) {
                    throw new EyesException("Failed to connect to server ", e);
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new EyesException("", e);
        }
        return result[0];
    }

    public TestResults stopSession(final RunningSession runningSession, final boolean isAborted, final boolean save) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        final TestResults[] result = new TestResults[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = RestClient.this.mServerUrl.toString() + "/api/sessions/running/{session_id}".replace("{session_id}", runningSession.getId()) + "?apiKey=" + RestClient.this.getApiKey() + "&aborted=" + isAborted + "&updateBaseline=" + save;
                    ResponseObject responseObject = RestClient.this.makeRequest(url, null, "DELETE");
                    result[0] = (TestResults)RestClient.this.mObjectMapper.readValue(responseObject.getMessage(), TestResults.class);
                }
                catch (IOException | InterruptedException e) {
                    throw new EyesException("Stop session failed: ", e);
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    public MatchResult matchWindow(final RunningSession runningSession, final MatchData matchData) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(matchData, "data");
        this.tryToUploadImage(matchData.getAppOutput());
        final MatchResult[] result = new MatchResult[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = RestClient.this.mServerUrl.toString() + "/api/sessions/running/{session_id}".replace("{session_id}", runningSession.getId()) + "?apiKey=" + RestClient.this.getApiKey();
                    ResponseObject responseObject = RestClient.this.makeRequest(url, RestClient.this.mObjectMapper.writeValueAsString((Object)matchData), "POST");
                    result[0] = (MatchResult)RestClient.this.mObjectMapper.readValue(responseObject.getMessage(), MatchResult.class);
                }
                catch (IOException | InterruptedException e) {
                    throw new EyesException("Match window failed: ", e);
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    public MatchResult matchWindow(final RunningSession runningSession, final MatchWindowData matchWindowData) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(matchWindowData, "data");
        this.tryToUploadImage(matchWindowData.getAppOutput());
        final MatchResult[] result = new MatchResult[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = RestClient.this.mServerUrl.toString() + "/api/sessions/running/{session_id}".replace("{session_id}", runningSession.getId()) + "?apiKey=" + RestClient.this.getApiKey();
                    ResponseObject responseObject = RestClient.this.makeRequest(url, RestClient.this.mObjectMapper.writeValueAsString((Object)matchWindowData), "POST");
                    result[0] = (MatchResult)RestClient.this.mObjectMapper.readValue(responseObject.getMessage(), MatchResult.class);
                }
                catch (IOException | InterruptedException e) {
                    throw new EyesException("Match window failed: ", e);
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    public void closeBatch(final String batchId) {
        if ("true".equalsIgnoreCase(GeneralUtils.getEnvString("APPLITOOLS_DONT_CLOSE_BATCHES"))) {
            this.mLogger.log("APPLITOOLS_DONT_CLOSE_BATCHES environment variable set to true. Doing nothing.");
            return;
        }
        ArgumentGuard.notNull(batchId, "batchId");
        this.mLogger.verbose("called with " + batchId);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = RestClient.this.mServerUrl.toString() + "/api/sessions/batches/{batch_id}/close/bypointerid".replace("{batch_id}", batchId) + "?apiKey=" + RestClient.this.getApiKey();
                    ResponseObject responseObject = RestClient.this.makeRequest(url, null, "DELETE");
                    RestClient.this.mLogger.verbose("delete batch is done with " + responseObject.getCode() + " status");
                }
                catch (IOException | InterruptedException e) {
                    throw new EyesException("Close batch failed: ", e);
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void tryToUploadImage(AppOutput appOutput) {
        RenderingInfo renderingInfo;
        if (appOutput.getScreenshotUrl() == null && (renderingInfo = this.getRenderingInfo()) != null && renderingInfo.getResultsUrl() != null) {
            String imageTargetUrl = renderingInfo.getResultsUrl().toString();
            imageTargetUrl = imageTargetUrl.replace("__random__", UUID.randomUUID().toString());
            this.mLogger.verbose("Uploading image to: " + imageTargetUrl);
            try {
                ResponseObject response = this.uploadImage(appOutput.getScreenshotBytes(), renderingInfo, imageTargetUrl);
                if (response.getCode() != 200 && response.getCode() != 201) {
                    throw new EyesException("MatchWindow failed: could not upload image to storage service.");
                }
                appOutput.setScreenshotUrl(imageTargetUrl);
                this.mLogger.verbose("Image was uploaded");
            }
            catch (IOException e) {
                throw new EyesException("Image uploading failed: ", e);
            }
        }
    }

    private RenderingInfo getRenderingInfo() {
        this.mLogger.verbose("getRenderingInfo()");
        if (this.mRenderingInfo == null) {
            this.mLogger.verbose("trying to get rendering info...");
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String url = RestClient.this.mServerUrl.toString() + "/api/sessions/renderinfo" + "?apiKey=" + RestClient.this.getApiKey();
                        ResponseObject responseObject = RestClient.this.makeRequest(url, null, "GET");
                        RestClient.this.mRenderingInfo = (RenderingInfo)RestClient.this.mObjectMapper.readValue(responseObject.getMessage(), RenderingInfo.class);
                    }
                    catch (IOException | InterruptedException e) {
                        throw new EyesException("GetRenderingInfo failed:", e);
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            this.mLogger.verbose("returning cached rendering info.");
        }
        return this.mRenderingInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObject uploadImage(byte[] imageBytes, RenderingInfo renderingInfo, String imageTargetUrl) throws IOException {
        int responseCode = 0;
        StringBuilder response = new StringBuilder();
        this.mLogger.verbose("trying to upload image...");
        boolean isSuccess = false;
        int retryCount = 0;
        while (!isSuccess && retryCount < 3) {
            this.mLogger.verbose("Attempt to send request number " + ++retryCount);
            HttpURLConnection conn = this.getConnection(imageTargetUrl);
            try {
                String line;
                conn.setRequestProperty("Content-Type", "image/png");
                conn.setRequestProperty("Content-Length", String.valueOf(imageBytes.length));
                conn.setRequestProperty("X-Auth-Token", renderingInfo.getAccessToken());
                conn.setRequestProperty("x-ms-blob-type", "BlockBlob");
                conn.setRequestProperty("Date", new Date(System.currentTimeMillis()).toString());
                conn.setRequestProperty("x-applitools-eyes-client", this.mAgentId);
                conn.setUseCaches(false);
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("PUT");
                conn.connect();
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                out.write(imageBytes, 0, imageBytes.length);
                out.flush();
                out.close();
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                isSuccess = true;
                responseCode = conn.getResponseCode();
                this.mLogger.verbose("Response Code : " + responseCode);
                this.mLogger.verbose("Response Body : " + response.toString());
            }
            catch (Exception e) {
                this.mLogger.verbose("Error while uploading image: " + e.getMessage());
                isSuccess = false;
            }
            finally {
                responseCode = conn.getResponseCode();
                conn.disconnect();
            }
        }
        return new ResponseObject(responseCode, response.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseObject makeRequest(String url, String requestBody, String requestMethod) throws IOException, InterruptedException {
        int responseCode = 0;
        StringBuilder response = new StringBuilder();
        String locationUrl = null;
        boolean isSuccess = false;
        int retryCount = 0;
        while (!isSuccess && retryCount < 3) {
            this.mLogger.verbose("Attempt to send request number " + ++retryCount);
            HttpURLConnection conn = this.getConnection(url);
            try {
                String line;
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Eyes-Expect", "202+location");
                conn.setRequestProperty("Eyes-Date", GeneralUtils.toRfc1123(Calendar.getInstance()));
                conn.setRequestProperty("x-applitools-eyes-client", this.mAgentId);
                conn.setUseCaches(false);
                conn.setRequestMethod(requestMethod);
                if (requestMethod.equals("POST")) {
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                }
                conn.connect();
                this.mLogger.verbose("Sending '" + requestMethod + "' request to URL : " + url);
                this.mLogger.verbose("Request body : " + requestBody);
                if (requestBody != null) {
                    DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                    out.writeBytes(requestBody);
                    out.flush();
                    out.close();
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                isSuccess = true;
                locationUrl = conn.getHeaderField("Location");
            }
            catch (Exception e) {
                isSuccess = false;
            }
            finally {
                responseCode = conn.getResponseCode();
                conn.disconnect();
            }
        }
        ResponseObject responseObject = this.checkStatus(locationUrl, new ResponseObject(responseCode, response.toString()));
        this.mLogger.verbose("Response Code : " + responseObject.getCode());
        this.mLogger.verbose("Response Body : " + responseObject.getMessage());
        return responseObject;
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn;
        URL obj = new URL(url);
        try {
            if (this.mProxySettings != null) {
                this.mLogger.log("Connection with proxy");
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.mProxySettings.getIp(), this.mProxySettings.getPort()));
                if (this.mProxySettings.getUsername() != null && this.mProxySettings.getPassword() != null) {
                    Authenticator authenticator = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(RestClient.this.mProxySettings.getUsername(), RestClient.this.mProxySettings.getPassword().toCharArray());
                        }
                    };
                    Authenticator.setDefault(authenticator);
                }
                conn = (HttpURLConnection)obj.openConnection(proxy);
            } else {
                this.mLogger.log("Connection without proxy");
                conn = (HttpURLConnection)obj.openConnection();
            }
        }
        catch (IOException e) {
            this.mLogger.verbose("Exception while opening connection: " + e.getMessage());
            e.printStackTrace();
            throw new IOException(e.getCause());
        }
        return conn;
    }

    private ResponseObject checkStatus(String locationUrl, ResponseObject responseObject) throws InterruptedException, IOException {
        if (responseObject.getCode() == 200 || locationUrl == null) {
            return responseObject;
        }
        if (responseObject.getCode() == 202) {
            return this.longRequest(locationUrl, 2000);
        }
        if (responseObject.getCode() == 201) {
            return this.deleteLongRequest(locationUrl);
        }
        if (responseObject.getCode() == 410) {
            throw new EyesException("The server task has gone");
        }
        throw new EyesException("Unknown error during long request: " + responseObject.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObject longRequest(String url, int delay) throws InterruptedException, IOException {
        String location;
        delay = Math.min(10000, (int)Math.floor((double)delay * 1.5));
        this.mLogger.verbose("Still running... Retrying in " + delay + " ms");
        Thread.sleep(delay);
        StringBuilder response = new StringBuilder();
        HttpURLConnection conn = this.getConnection(url + "?apiKey=" + this.getApiKey());
        int responseCode = 0;
        try {
            String line;
            conn.setRequestProperty("Eyes-Date", GeneralUtils.toRfc1123(Calendar.getInstance()));
            conn.setRequestProperty("x-applitools-eyes-client", this.mAgentId);
            conn.setRequestMethod("GET");
            conn.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
        }
        catch (Exception exception) {
        }
        finally {
            responseCode = conn.getResponseCode();
            location = conn.getHeaderField("Location");
            conn.disconnect();
        }
        if (responseCode != 200) {
            url = location;
            return this.checkStatus(url, new ResponseObject(responseCode, response.toString()));
        }
        return this.checkStatus(url, this.longRequest(url, delay));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObject deleteLongRequest(String url) throws IOException {
        int responseCode;
        StringBuilder response = new StringBuilder();
        HttpURLConnection conn = this.getConnection(url + "?apiKey=" + this.getApiKey());
        try {
            String line;
            conn.setRequestProperty("Eyes-Date", GeneralUtils.toRfc1123(Calendar.getInstance()));
            conn.setRequestProperty("x-applitools-eyes-client", this.mAgentId);
            conn.setUseCaches(false);
            conn.setRequestMethod("DELETE");
            conn.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
        }
        catch (Exception exception) {
        }
        finally {
            responseCode = conn.getResponseCode();
            conn.disconnect();
        }
        return new ResponseObject(responseCode, response.toString());
    }
}

