/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common.utils;

import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GeneralUtils {
    public static final String APPLITOOLS_SERVER_URL = "APPLITOOLS_SERVER_URL";
    public static final String APPLITOOLS_API_KEY = "APPLITOOLS_API_KEY";
    public static final String APPLITOOLS_BATCH_ID = "APPLITOOLS_BATCH_ID";
    public static final String APPLITOOLS_BATCH_NAME = "APPLITOOLS_BATCH_NAME";
    public static final String APPLITOOLS_BATCH_SEQUENCE = "APPLITOOLS_BATCH_SEQUENCE";
    public static final String APPLITOOLS_BATCH_NOTIFY = "APPLITOOLS_BATCH_NOTIFY";
    public static final String APPLITOOLS_BRANCH = "APPLITOOLS_BRANCH";
    public static final String APPLITOOLS_PARENT_BRANCH = "APPLITOOLS_PARENT_BRANCH";
    public static final String APPLITOOLS_BASELINE_BRANCH = "APPLITOOLS_BASELINE_BRANCH";
    public static final String APPLITOOLS_DONT_CLOSE_BATCHES = "APPLITOOLS_DONT_CLOSE_BATCHES";
    private static final String DATE_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DATE_FORMAT_RFC1123 = "E, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String DATE_FORMAT_ISO8601_FOR_INPUT = "yyyy-MM-dd'T'HH:mm:ssXXX";

    private GeneralUtils() {
    }

    public static String readToEnd(InputStream inputStream) throws IOException {
        int length;
        ArgumentGuard.notNull(inputStream, "inputStream");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return new String(baos.toByteArray());
    }

    public static String toISO8601DateTime(Calendar calendar) {
        ArgumentGuard.notNull(calendar, "calendar");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_ISO8601, Locale.US);
        formatter.setTimeZone(calendar.getTimeZone());
        return formatter.format(calendar.getTime());
    }

    public static String toRfc1123(Calendar calendar) {
        ArgumentGuard.notNull(calendar, "calendar");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_RFC1123, Locale.US);
        formatter.setTimeZone(calendar.getTimeZone());
        return formatter.format(calendar.getTime());
    }

    public static Calendar fromISO8601DateTime(String dateTime) throws ParseException {
        ArgumentGuard.notNull(dateTime, "dateTime");
        String timezoneId = "UTC";
        if (dateTime.contains("T")) {
            if (dateTime.endsWith("Z")) {
                dateTime = dateTime.replaceAll("\\.(\\d+)Z", "Z");
            } else if (dateTime.contains("+")) {
                dateTime = dateTime.replaceAll("\\.(\\d+)\\+", "+");
                timezoneId = timezoneId + "+" + dateTime.split("\\+")[1];
            } else if (dateTime.contains("-")) {
                dateTime = dateTime.replaceAll("\\.(\\d+)\\+", "+");
                timezoneId = timezoneId + "-" + dateTime.split("-")[1];
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_ISO8601_FOR_INPUT);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezoneId));
        cal.setTime(formatter.parse(dateTime));
        return cal;
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("sleep interrupted", ex);
        }
    }

    public static Date getDate(DateFormat format, String date) {
        try {
            return format.parse(date);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static long getFullSecondsElapsedTimeMillis(long start, long end) {
        return (long)Math.ceil((double)(end - start) / 1000.0) * 1000L;
    }

    public static String readTextFromResource(String resource) {
        InputStream is = GeneralUtils.class.getClassLoader().getResourceAsStream(resource);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EyesException("Failed to read text from resource: ", e);
        }
        return sb.toString();
    }

    public static String getEnvString(String variableName) {
        return System.getenv(variableName) == null ? System.getenv("bamboo_" + variableName) : System.getenv(variableName);
    }

    public static void logExceptionStackTrace(Logger logger, Throwable ex) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
        PrintWriter writer = new PrintWriter(stream, true);
        ex.printStackTrace(writer);
        logger.log(ex.toString());
        try {
            logger.log(stream.toString("UTF-8"));
            writer.close();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

