/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.common.utils.GeneralUtils;
import com.applitools.eyes.android.common.utils.Iso8610CalendarSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public class BatchInfo {
    private static final String BATCH_TIMEZONE = "UTC";
    private String id;
    @JsonProperty(value="batchSequenceName")
    private String batchSequenceName;
    private final String name;
    private final String startedAt;
    private boolean notifyOnCompletion = false;

    public BatchInfo(String name, Calendar startedAt) {
        ArgumentGuard.notNull(startedAt, "startedAt");
        String envVarBatchId = GeneralUtils.getResourceProperty("APPLITOOLS_BATCH_ID");
        this.id = envVarBatchId != null ? envVarBatchId : UUID.randomUUID().toString();
        this.name = name != null ? name : GeneralUtils.getResourceProperty("APPLITOOLS_BATCH_NAME");
        this.startedAt = GeneralUtils.toISO8601DateTime(startedAt);
        this.batchSequenceName = GeneralUtils.getResourceProperty("APPLITOOLS_BATCH_SEQUENCE");
        String envBatchNotify = GeneralUtils.getResourceProperty("APPLITOOLS_BATCH_NOTIFY");
        if (envBatchNotify != null) {
            this.notifyOnCompletion = Boolean.parseBoolean(envBatchNotify);
        }
    }

    public BatchInfo(String name) {
        this(name, Calendar.getInstance(TimeZone.getTimeZone(BATCH_TIMEZONE)));
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        ArgumentGuard.notNullOrEmpty(id, "id");
        this.id = id;
    }

    @JsonSerialize(using=Iso8610CalendarSerializer.class)
    public Calendar getStartedAt() {
        try {
            return GeneralUtils.fromISO8601DateTime(this.startedAt);
        }
        catch (ParseException ex) {
            throw new EyesException("Failed to parse batch start time", ex);
        }
    }

    @JsonProperty(value="batchSequenceName")
    public String getSequenceName() {
        return this.batchSequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.batchSequenceName = sequenceName;
    }

    public boolean isNotifyOnCompletion() {
        return this.notifyOnCompletion;
    }

    public void setNotifyOnCompletion(boolean notifyOnCompletion) {
        this.notifyOnCompletion = notifyOnCompletion;
    }

    public String toString() {
        return "'" + this.name + "' - " + this.startedAt;
    }
}

