/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import com.applitools.eyes.android.common.ImageMatchSettings;
import com.applitools.eyes.android.common.SessionAccessibilityStatus;
import com.applitools.eyes.android.common.SessionUrls;
import com.applitools.eyes.android.common.TestResultsStatus;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"$id", "isPassed", "$url"}, ignoreUnknown=true)
public class TestResults {
    @JsonProperty(value="Steps")
    private int steps;
    @JsonProperty(value="Matches")
    private int matches;
    @JsonProperty(value="Mismatches")
    private int mismatches;
    @JsonProperty(value="Missing")
    private int missing;
    @JsonProperty(value="ExactMatches")
    private int exactMatches;
    @JsonProperty(value="StrictMatches")
    private int strictMatches;
    @JsonProperty(value="ContentMatches")
    private int contentMatches;
    @JsonProperty(value="LayoutMatches")
    private int layoutMatches;
    @JsonProperty(value="NoneMatches")
    private int noneMatches;
    @JsonIgnore
    private String url;
    @JsonProperty(value="IsNew")
    private boolean isNew;
    @JsonProperty(value="IsDifferent")
    private boolean isDifferent;
    @JsonProperty(value="IsAborted")
    private boolean isAborted;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="AppName")
    private String appName;
    private SessionAccessibilityStatus accessibilityStatus;
    private TestResultsStatus status;
    private ImageMatchSettings defaultMatchSettings;
    private SessionUrls apiUrls;
    private String secretToken;

    public int getSteps() {
        return this.steps;
    }

    public int getMatches() {
        return this.matches;
    }

    public int getMismatches() {
        return this.mismatches;
    }

    public int getMissing() {
        return this.missing;
    }

    public int getExactMatches() {
        return this.exactMatches;
    }

    public int getStrictMatches() {
        return this.strictMatches;
    }

    public int getContentMatches() {
        return this.contentMatches;
    }

    public int getLayoutMatches() {
        return this.layoutMatches;
    }

    public int getNoneMatches() {
        return this.noneMatches;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isPassed() {
        return this.status == TestResultsStatus.Passed;
    }

    void setSteps(int steps) {
        ArgumentGuard.greaterThanOrEqualToZero(steps, "steps");
        this.steps = steps;
    }

    void setMatches(int matches) {
        ArgumentGuard.greaterThanOrEqualToZero(matches, "matches");
        this.matches = matches;
    }

    void setMismatches(int mismatches) {
        ArgumentGuard.greaterThanOrEqualToZero(mismatches, "mismatches");
        this.mismatches = mismatches;
    }

    void setMissing(int missing) {
        ArgumentGuard.greaterThanOrEqualToZero(missing, "missing");
        this.missing = missing;
    }

    void setExactMatches(int exactMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(exactMatches, "exactMatches");
        this.exactMatches = exactMatches;
    }

    void setStrictMatches(int strictMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(strictMatches, "strictMatches");
        this.strictMatches = strictMatches;
    }

    void setContentMatches(int contentMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(contentMatches, "contentMatches");
        this.contentMatches = contentMatches;
    }

    void setLayoutMatches(int layoutMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(layoutMatches, "layoutMatches");
        this.layoutMatches = layoutMatches;
    }

    void setNoneMatches(int noneMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(noneMatches, "noneMatches");
        this.noneMatches = noneMatches;
    }

    public SessionAccessibilityStatus getAccessibilityStatus() {
        return this.accessibilityStatus;
    }

    public void setAccessibilityStatus(SessionAccessibilityStatus accessibilityStatus) {
        this.accessibilityStatus = accessibilityStatus;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isDifferent() {
        return this.isDifferent;
    }

    public void setDifferent(boolean isDifferent) {
        this.isDifferent = isDifferent;
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public void setAborted(boolean isAborted) {
        this.isAborted = isAborted;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    void setStatus(TestResultsStatus status) {
        this.status = status;
    }

    public TestResultsStatus getStatus() {
        return this.status;
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.defaultMatchSettings;
    }

    public void setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.defaultMatchSettings = defaultMatchSettings;
    }

    public SessionUrls getApiUrls() {
        return this.apiUrls;
    }

    public void setApiUrls(SessionUrls apiUrls) {
        this.apiUrls = apiUrls;
    }

    public String getSecretToken() {
        return this.secretToken;
    }

    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public String toString() {
        String isNewTestStr = this.isNew ? "New test" : "Existing test";
        return isNewTestStr + " [ steps: " + this.getSteps() + ", matches: " + this.getMatches() + ", mismatches:" + this.getMismatches() + ", missing: " + this.getMissing() + "] , URL: " + this.getUrl();
    }
}

