/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import com.applitools.eyes.android.common.TestResultContainer;
import com.applitools.eyes.android.common.TestResults;
import java.util.Iterator;
import java.util.List;

public class TestResultsSummary
implements Iterable<TestResultContainer> {
    private List<TestResultContainer> allResults;
    private int passed = 0;
    private int unresolved = 0;
    private int failed = 0;
    private int exceptions = 0;
    private int mismatches = 0;
    private int missing = 0;
    private int matches = 0;

    public TestResultsSummary(List<TestResultContainer> allResults) {
        this.allResults = allResults;
        for (TestResultContainer resultContainer : allResults) {
            TestResults result;
            if (resultContainer != null && resultContainer.getException() != null) {
                ++this.exceptions;
            }
            if ((result = resultContainer.getTestResults()) == null) continue;
            if (result.getStatus() != null) {
                switch (result.getStatus()) {
                    case Failed: {
                        ++this.failed;
                        break;
                    }
                    case Passed: {
                        ++this.passed;
                        break;
                    }
                    case Unresolved: {
                        ++this.unresolved;
                    }
                }
            }
            this.matches += result.getMatches();
            this.missing += result.getMissing();
            this.mismatches += result.getMismatches();
        }
    }

    public TestResultContainer[] getAllResults() {
        return this.allResults.toArray(new TestResultContainer[0]);
    }

    public String toString() {
        StringBuilder allResultsStr = new StringBuilder();
        for (TestResultContainer container : this.allResults) {
            allResultsStr.append(container);
            if (this.allResults.indexOf(container) == this.allResults.size() - 1) continue;
            allResultsStr.append("\n\t\t");
        }
        return "result summary {\n\tall results=\n\t\t" + allResultsStr + "\n\tpassed=" + this.passed + "\n\tunresolved=" + this.unresolved + "\n\tfailed=" + this.failed + "\n\texceptions=" + this.exceptions + "\n\tmismatches=" + this.mismatches + "\n\tmissing=" + this.missing + "\n\tmatches=" + this.matches + "\n}";
    }

    @Override
    public Iterator<TestResultContainer> iterator() {
        return this.allResults.iterator();
    }

    public int size() {
        return this.allResults.size();
    }
}

