/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common.config;

import com.applitools.eyes.android.common.AbstractProxySettings;
import com.applitools.eyes.android.common.AccessibilitySettings;
import com.applitools.eyes.android.common.BatchInfo;
import com.applitools.eyes.android.common.Feature;
import com.applitools.eyes.android.common.ImageMatchSettings;
import com.applitools.eyes.android.common.MatchLevel;
import com.applitools.eyes.android.common.RectangleSize;
import com.applitools.eyes.android.common.SessionType;
import com.applitools.eyes.android.common.config.IConfigurationGetter;
import com.applitools.eyes.android.common.config.IConfigurationSetter;
import com.applitools.eyes.android.common.utils.GeneralUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Configuration
implements IConfigurationSetter,
IConfigurationGetter {
    private static final int DEFAULT_MATCH_TIMEOUT = 2000;
    private String branchName = GeneralUtils.getResourceProperty("APPLITOOLS_BRANCH");
    private String parentBranchName = GeneralUtils.getResourceProperty("APPLITOOLS_PARENT_BRANCH");
    private String baselineBranchName = GeneralUtils.getResourceProperty("APPLITOOLS_BASELINE_BRANCH");
    private String agentId;
    private String environmentName;
    private Boolean saveDiffs;
    private SessionType sessionType;
    protected BatchInfo batch = new BatchInfo(null);
    protected String baselineEnvName;
    protected String appName;
    protected String testName;
    protected RectangleSize viewportSize;
    private ImageMatchSettings defaultMatchSettings = new ImageMatchSettings();
    private int matchTimeout = 2000;
    private String hostApp;
    private String hostOS;
    private boolean saveNewTests;
    private boolean saveFailedTests;
    private int stitchOverlap = 0;
    private Boolean isSendDom = true;
    private String apiKey = null;
    private String serverUrl = null;
    private AbstractProxySettings proxy = null;
    private boolean hideCaret = true;
    private Boolean forceFullPageScreenshot = true;
    private List<Feature> features = new ArrayList<Feature>();

    public Configuration(IConfigurationGetter other) {
        this.branchName = other.getBranchName();
        this.parentBranchName = other.getParentBranchName();
        this.baselineBranchName = other.getBaselineBranchName();
        this.agentId = other.getAgentId();
        this.environmentName = other.getEnvironmentName();
        this.saveDiffs = other.getSaveDiffs();
        this.sessionType = other.getSessionType();
        this.batch = other.getBatch();
        this.baselineEnvName = other.getBaselineEnvName();
        this.appName = other.getAppName();
        this.testName = other.getTestName();
        this.viewportSize = other.getViewportSize();
        this.defaultMatchSettings = new ImageMatchSettings(other.getDefaultMatchSettings());
        this.matchTimeout = other.getMatchTimeout();
        this.hostApp = other.getHostApp();
        this.hostOS = other.getHostOS();
        this.saveNewTests = other.getSaveNewTests();
        this.saveFailedTests = other.getSaveFailedTests();
        this.stitchOverlap = other.getStitchOverlap();
        this.isSendDom = other.isSendDom();
        this.apiKey = other.getApiKey();
        URI serverUrl = other.getServerUrl();
        if (serverUrl != null) {
            this.serverUrl = serverUrl.toString();
        }
        this.proxy = other.getProxy();
        if (other.getMatchLevel() != null) {
            this.defaultMatchSettings.setMatchLevel(other.getMatchLevel());
        }
        this.forceFullPageScreenshot = other.getForceFullPageScreenshot();
        this.features = other.getFeatures();
    }

    public Configuration() {
        this.defaultMatchSettings.setIgnoreCaret(true);
        this.agentId = null;
        this.saveNewTests = true;
        this.saveFailedTests = false;
    }

    @Override
    public boolean getSaveNewTests() {
        return this.saveNewTests;
    }

    @Override
    public IConfigurationSetter setSaveNewTests(boolean saveNewTests) {
        this.saveNewTests = saveNewTests;
        return this;
    }

    @Override
    public boolean getSaveFailedTests() {
        return this.saveFailedTests;
    }

    @Override
    public IConfigurationSetter setSaveFailedTests(boolean saveFailedTests) {
        this.saveFailedTests = saveFailedTests;
        return this;
    }

    @Override
    public ImageMatchSettings getDefaultMatchSettings() {
        return this.defaultMatchSettings;
    }

    @Override
    public IConfigurationSetter setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.defaultMatchSettings = defaultMatchSettings;
        return this;
    }

    @Override
    public int getMatchTimeout() {
        return this.matchTimeout;
    }

    @Override
    public IConfigurationSetter setMatchTimeout(int matchTimeout) {
        this.matchTimeout = matchTimeout;
        return this;
    }

    @Override
    public String getHostApp() {
        return this.hostApp;
    }

    @Override
    public IConfigurationSetter setHostApp(String hostApp) {
        this.hostApp = hostApp;
        return this;
    }

    @Override
    public String getHostOS() {
        return this.hostOS;
    }

    @Override
    public IConfigurationSetter setHostOS(String hostOS) {
        this.hostOS = hostOS;
        return this;
    }

    @Override
    public int getStitchOverlap() {
        return this.stitchOverlap;
    }

    @Override
    public IConfigurationSetter setStitchOverlap(int stitchOverlap) {
        this.stitchOverlap = stitchOverlap;
        return this;
    }

    @Override
    public IConfigurationSetter setBatch(BatchInfo batch) {
        this.batch = batch;
        return this;
    }

    @Override
    public BatchInfo getBatch() {
        return this.batch;
    }

    @Override
    public IConfigurationSetter setBranchName(String branchName) {
        this.branchName = branchName;
        return this;
    }

    @Override
    public String getBranchName() {
        return this.branchName;
    }

    @Override
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    public IConfigurationSetter setAgentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @Override
    public String getParentBranchName() {
        return this.parentBranchName;
    }

    @Override
    public IConfigurationSetter setParentBranchName(String parentBranchName) {
        this.parentBranchName = parentBranchName;
        return this;
    }

    @Override
    public String getBaselineBranchName() {
        return this.baselineBranchName;
    }

    @Override
    public IConfigurationSetter setBaselineBranchName(String baselineBranchName) {
        this.baselineBranchName = baselineBranchName;
        return this;
    }

    @Override
    public String getBaselineEnvName() {
        return this.baselineEnvName;
    }

    @Override
    public IConfigurationSetter setBaselineEnvName(String baselineEnvName) {
        this.baselineEnvName = baselineEnvName;
        return this;
    }

    @Override
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    public IConfigurationSetter setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public Boolean getSaveDiffs() {
        return this.saveDiffs;
    }

    @Override
    public IConfigurationSetter setSaveDiffs(Boolean saveDiffs) {
        this.saveDiffs = saveDiffs;
        return this;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public IConfigurationSetter setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public IConfigurationSetter setTestName(String testName) {
        this.testName = testName;
        return this;
    }

    @Override
    public RectangleSize getViewportSize() {
        return this.viewportSize;
    }

    @Override
    public IConfigurationSetter setViewportSize(RectangleSize viewportSize) {
        this.viewportSize = viewportSize;
        return this;
    }

    @Override
    public SessionType getSessionType() {
        return this.sessionType;
    }

    @Override
    public IConfigurationSetter setSessionType(SessionType sessionType) {
        this.sessionType = sessionType;
        return this;
    }

    public Configuration cloneConfig() {
        return new Configuration(this);
    }

    public String toString() {
        return super.toString() + "\n\tbatch = " + this.batch + "\n\tbranchName = " + this.branchName + "\n\tparentBranchName = " + this.parentBranchName + "\n\tagentId = " + this.agentId + "\n\tbaselineEnvName = " + this.baselineEnvName + "\n\tenvironmentName = " + this.environmentName + "\n\tsaveDiffs = " + this.saveDiffs + "\n\tappName = " + this.appName + "\n\ttestName = " + this.testName + "\n\tviewportSize = " + this.viewportSize + "\n\tsessionType = " + (Object)((Object)this.sessionType);
    }

    @Override
    public Boolean isSendDom() {
        return this.isSendDom;
    }

    @Override
    public IConfigurationSetter setSendDom(boolean sendDom) {
        this.isSendDom = sendDom;
        return this;
    }

    @Override
    public boolean getIgnoreCaret() {
        Boolean ignoreCaret = this.getDefaultMatchSettings().getIgnoreCaret();
        return ignoreCaret == null ? true : ignoreCaret;
    }

    @Override
    public IConfigurationSetter setIgnoreCaret(boolean value) {
        this.defaultMatchSettings.setIgnoreCaret(value);
        return this;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public IConfigurationSetter setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public URI getServerUrl() {
        if (this.serverUrl != null) {
            return URI.create(this.serverUrl);
        }
        return null;
    }

    @Override
    public IConfigurationSetter setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    @Override
    public AbstractProxySettings getProxy() {
        return this.proxy;
    }

    @Override
    public IConfigurationSetter setProxy(AbstractProxySettings proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.defaultMatchSettings.getMatchLevel();
    }

    @Override
    public boolean getIgnoreDisplacements() {
        return this.defaultMatchSettings.getIgnoreDisplacements();
    }

    @Override
    public IConfigurationSetter setMatchLevel(MatchLevel matchLevel) {
        this.defaultMatchSettings.setMatchLevel(matchLevel);
        return this;
    }

    @Override
    public IConfigurationSetter setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        this.defaultMatchSettings.setIgnoreDisplacements(isIgnoreDisplacements);
        return this;
    }

    @Override
    public boolean getHideCaret() {
        return this.hideCaret;
    }

    @Override
    public IConfigurationSetter setHideCaret(boolean hideCaret) {
        this.hideCaret = hideCaret;
        return this;
    }

    @Override
    public AccessibilitySettings getAccessibilityValidation() {
        return this.defaultMatchSettings.getAccessibilitySettings();
    }

    @Override
    public boolean getEnablePatterns() {
        return this.defaultMatchSettings.isEnablePatterns();
    }

    @Override
    public Boolean getForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    @Override
    public List<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public IConfigurationSetter setAccessibilityValidation(AccessibilitySettings accessibilitySettings) {
        this.defaultMatchSettings.setAccessibilitySettings(accessibilitySettings);
        return this;
    }

    @Override
    public IConfigurationSetter setEnablePatterns(boolean enablePatterns) {
        this.defaultMatchSettings.setEnablePatterns(enablePatterns);
        return this;
    }

    @Override
    public IConfigurationSetter setForceFullPageScreenshot(boolean forceFullPageScreenshot) {
        this.forceFullPageScreenshot = forceFullPageScreenshot;
        return this;
    }

    @Override
    public IConfigurationSetter setFeatures(Feature ... features) {
        this.features.clear();
        this.features.addAll(Arrays.asList(features));
        return this;
    }
}

