package com.applitools.eyes.android.espresso;

import com.applitools.eyes.android.common.EyesRunner;
import com.applitools.eyes.android.common.TestResultContainer;
import com.applitools.eyes.android.common.TestResults;
import com.applitools.eyes.android.common.TestResultsSummary;
import com.applitools.eyes.android.core.EyesBase;

import java.util.ArrayList;
import java.util.List;

public class ClassicRunner extends EyesRunner {

    private Error exception;

    @Override
    public TestResultsSummary getAllTestResultsImpl(){
        return getAllTestResults(true);
    }

    @Override
    public TestResultsSummary getAllTestResultsImpl(boolean shouldThrowException) {
        if (shouldThrowException && exception != null) {
            throw exception;
        }
        List<TestResultContainer> result = new ArrayList<>();
        for (TestResults testResults : allTestResult) {
            result.add(new TestResultContainer(testResults, null));
            EyesBase.logSessionResultsAndThrowException(logger, shouldThrowException, testResults);
        }
        return new TestResultsSummary(result);
    }

    public void setException(Error exception) {
        this.exception = exception;
    }
}
