package com.applitools.eyes.android.espresso;

import android.app.Activity;
import android.graphics.Bitmap;

import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.core.ScreenshotProvider;
import com.applitools.eyes.android.espresso.utils.ImageUtils;

class CurrentFrameScreenshotProvider implements ScreenshotProvider {

    private boolean mIncludeAllLayers;
    private boolean mHideCaret;
    private IComponentsProvider mComponentsProvider;

    public CurrentFrameScreenshotProvider(boolean includeAllLayers, boolean hideCaret,
                                          IComponentsProvider componentsProvider) {
        this.mIncludeAllLayers = includeAllLayers;
        this.mHideCaret = hideCaret;
        this.mComponentsProvider = componentsProvider;
    }

    public byte[] getImage() {
        Bitmap bitmap;

        Activity activity = mComponentsProvider.getCurrentActivity();
        try {
            bitmap = mComponentsProvider.captureViewportScreenshot(activity, false, true,
                    mIncludeAllLayers, mHideCaret);
        } catch (Exception e) {
            throw new RuntimeException("Unable to capture screenshot.", e);
        }

        return ImageUtils.bitmapToBytes(bitmap);
    }
}
