package com.applitools.eyes.android.espresso;

import android.graphics.Bitmap;
import android.util.Base64;

import com.applitools.eyes.android.common.EyesScreenshot;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.exceptions.OutOfBoundsException;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.espresso.utils.ImageUtils;

class EyesImageScreenshot extends EyesScreenshot {

    private final Logger mLogger;
    private Bitmap mBitmap;

    /**
     * @param logger A Logger instance.
     * @param image The actual screenshot image.
     */
    public EyesImageScreenshot(Logger logger, byte[] image) {
        super(image);
        ArgumentGuard.notNull(logger, "logger");
        this.mLogger = logger;
        this.mBitmap = ImageUtils.bytesToBitmap(image);

        logger.verbose("Done!");
    }

    @Override
    public EyesScreenshot getSubScreenshot(Region region) {
        mLogger.verbose(String.format("getSubScreenshot([%s]",
                region));

        ArgumentGuard.notNull(region, "region");

        if ((region.getTop() + region.getHeight() > mBitmap.getHeight()) ||
                (region.getLeft() + region.getWidth()) > mBitmap.getWidth()) {
            throw new OutOfBoundsException(String.format(
                    "Region [%s] is out of screenshot bounds",
                    region));
        }

        Bitmap bitmap = Bitmap.createBitmap(mBitmap, region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
        EyesScreenshot screenshot = new EyesImageScreenshot(mLogger, ImageUtils.bitmapToBytes(bitmap));
        mLogger.verbose("Done!");
        return screenshot;
    }
}
