package com.applitools.eyes.android.espresso;

import com.applitools.eyes.android.common.EyesScreenshot;
import com.applitools.eyes.android.common.RectangleSize;
import com.applitools.eyes.android.common.config.Configuration;
import com.applitools.eyes.android.common.config.IConfigurationGetter;
import com.applitools.eyes.android.common.config.IConfigurationProvider;
import com.applitools.eyes.android.common.config.IConfigurationSetter;
import com.applitools.eyes.android.core.EyesBase;

public class TestEyes extends EyesBase implements IConfigurationProvider {

    private Configuration configuration = new Configuration();

    public TestEyes() {
        super(getDefaultServerUrl());
    }

    @Override
    protected String getBaseAgentId() {
        return "test-eyes";
    }

    @Override
    protected RectangleSize getViewportSize() {
        return new RectangleSize(1024, 1980);
    }

    @Override
    protected void setViewportSize(RectangleSize size) {

    }

    @Override
    protected EyesScreenshot getScreenshot(boolean includeAllLayers, boolean hideCaret) {
        return new TestEyesScreenshot();
    }

    @Override
    protected EyesScreenshot getScreenshot(byte[] bitmap) {
        return new TestEyesScreenshot(bitmap);
    }

    @Override
    protected String getTitle() {
        return "Application";
    }

    @Override
    protected String getDeviceModel() {
        return "Google Device";
    }

    @Override
    protected String getOsName() {
        return "Android";
    }

    @Override
    protected String getApplicationNameFromPackage() {
        return "TestApp";
    }

    @Override
    public IConfigurationProvider getConfigurationProvider() {
        return this;
    }


    @Override
    public IConfigurationGetter get() {
        return configuration;
    }

    @Override
    public IConfigurationSetter set() {
        return configuration;
    }
}
