package com.applitools.eyes.android.espresso;

import android.view.View;
import android.webkit.WebView;

import com.applitools.eyes.android.common.Location;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.core.RegionProvider;
import com.applitools.eyes.android.espresso.utils.ImageUtils;
import com.applitools.eyes.android.espresso.utils.LocationUtils;
import com.applitools.eyes.android.espresso.utils.RegionUtils;

public class ViewRegionProvider implements RegionProvider {

    private View mView;
    private boolean hideCaret;
    private IComponentsProvider mComponentsProvider;

    public ViewRegionProvider(View view, boolean hideCaret, IComponentsProvider componentsProvider) {
        mView = view;
        this.hideCaret = hideCaret;
        mComponentsProvider = componentsProvider;
    }

    @Override
    public Region getRegion() {
        if (mView instanceof WebView) {
            return RegionUtils.buildRegion(mView, mComponentsProvider);
        }
        return Region.EMPTY;
    }

    @Override
    public byte[] getImage() {
        if (mView instanceof WebView) {
            return null;
        }
        return ImageUtils.bitmapToBytes(mComponentsProvider.getBitmapFromView(mView, hideCaret));
    }

    @Override
    public Location getLocation() {
        return LocationUtils.getLocation(mView, mComponentsProvider);
    }
}
