package com.applitools.eyes.android.espresso.exceptions;

import com.applitools.eyes.android.common.exceptions.EyesException;

/**
 * Applitools Eyes exception indicating that reached timeout for taking screenshot.
 * Can be produced also if GoogleMap has not finished rendering.
 * Default value for timeout see at {@link com.applitools.eyes.android.espresso.Eyes#GOOGLE_MAP_SCREENSHOT_TIMEOUT}
 */
public class GoogleMapScreenshotTimeoutException extends EyesException {

    public GoogleMapScreenshotTimeoutException(String message) {
        super(message);
    }

    public GoogleMapScreenshotTimeoutException(String message, Throwable e) {
        super(message, e);
    }
}
