package com.applitools.eyes.android.espresso.fluent;

import android.view.View;

import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.core.fluent.CheckSettings;

import org.hamcrest.Matcher;

public class EspressoCheckSettings extends CheckSettings implements IEspressoCheckTarget, Cloneable {

    private Matcher mTargetMatcher;
    private View mTargetView;
    private boolean mGoogleMap = false;
    private boolean mIsNotSupportMap = false;
    private Integer mId;
    private boolean mDialog = false;
    private boolean mPopupView = false;

    EspressoCheckSettings() { }

    EspressoCheckSettings(Region region) {
        super(region);
    }

    EspressoCheckSettings(Matcher matcher) {
        this.mTargetMatcher = matcher;
    }

    EspressoCheckSettings(View view) {
        this.mTargetView = view;
    }

    EspressoCheckSettings(boolean googleMap) {
        this.mGoogleMap = googleMap;
    }

    @Override
    public Matcher getTargetMatcher() {
        return this.mTargetMatcher;
    }

    @Override
    public View getTargetView() {
        return this.mTargetView;
    }

    @Override
    public boolean isGoogleMap() {
        return mGoogleMap;
    }

    public boolean isNotSupportMap() {
        return mIsNotSupportMap;
    }

    @Override
    public Integer getId() {
        return mId;
    }

    @Override
    public boolean isDialogView() {
        return mDialog;
    }

    @Override
    public boolean isPopupView() {
        return mPopupView;
    }

    public EspressoCheckSettings region(Region region) {
        super.updateTargetRegion(region);
        return this;
    }

    public EspressoCheckSettings region(Matcher matcher) {
        this.mTargetMatcher = matcher;
        return this;
    }

    public EspressoCheckSettings ignore(Matcher... matchers) {
        for (Matcher matcher : matchers) {
            ignore(new IgnoreRegionBySelector(matcher));
        }

        return this;
    }

    public EspressoCheckSettings layout(Matcher... matchers) {
        for (Matcher matcher : matchers) {
            layout(new IgnoreRegionBySelector(matcher));
        }
        return this;
    }

    public EspressoCheckSettings content(Matcher... matchers) {
        for (Matcher matcher : matchers) {
            content(new IgnoreRegionBySelector(matcher));
        }
        return this;
    }

    public EspressoCheckSettings strict(Matcher... matchers) {
        for (Matcher matcher : matchers) {
            strict(new IgnoreRegionBySelector(matcher));
        }
        return this;
    }

    public EspressoCheckSettings isNotSupportGoogleMap() {
        this.mIsNotSupportMap = true;
        return this;
    }

    public EspressoCheckSettings id(int id) {
        this.mId = id;
        return this;
    }

    public EspressoCheckSettings dialog() {
        this.mDialog = true;
        return this;
    }

    public EspressoCheckSettings popup() {
        this.mPopupView = true;
        return this;
    }

    @Override
    public EspressoCheckSettings fully() {
        return (EspressoCheckSettings) super.fully();
    }

    @Override
    public EspressoCheckSettings fully(boolean fully) {
        return (EspressoCheckSettings) super.fully(fully);
    }

    @Override
    public EspressoCheckSettings clone(){
        EspressoCheckSettings clone = new EspressoCheckSettings();
        super.populateClone(clone);
        clone.mTargetMatcher = this.mTargetMatcher;
        clone.mTargetView = this.mTargetView;
        clone.mGoogleMap = this.mGoogleMap;
        clone.mIsNotSupportMap = this.mIsNotSupportMap;
        clone.mId = this.mId;
        clone.mDialog = this.mDialog;
        clone.mPopupView = this.mPopupView;
        return clone;
    }
}
