package com.applitools.eyes.android.espresso.fluent;

import android.view.View;

import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.core.EyesBase;
import com.applitools.eyes.android.core.fluent.GetRegion;
import com.applitools.eyes.android.espresso.Eyes;

import org.hamcrest.Matcher;

import java.util.ArrayList;
import java.util.List;

public class IgnoreRegionBySelector implements GetRegion {

    private Matcher mMatcher;

    public IgnoreRegionBySelector(Matcher matcher) {
        this.mMatcher = matcher;
    }

    @Override
    public List<Region> getRegions(EyesBase eyesBase) {
        View view = ((Eyes) eyesBase).getComponentsProvider().findView(mMatcher);
        if (view == null) {
            return null;
        }
        int[] locationAndSize = ((Eyes) eyesBase).getComponentsProvider().getViewPositionAndSize(view);
        locationAndSize[1] = locationAndSize[1] - ((Eyes) eyesBase).getComponentsProvider().getStatusBarHeight(view.getContext());
        List<Region> value = new ArrayList<>();
        value.add(new Region(locationAndSize[2], locationAndSize[3], locationAndSize[1], locationAndSize[0]));
        return value;
    }
}
