package com.applitools.eyes.android.espresso.logger;

import android.annotation.SuppressLint;

import java.io.File;

abstract class CommandLineUtils {

    private static final CommandLineUtils sInstance;

    static {
        sInstance = new Java6Chmod();
    }

    static void cmdPermissionR(File file) {
        sInstance.permissionR(file);
    }

    static void cmdPermissionRWX(File file) {
        sInstance.permissionRWX(file);
    }

    protected abstract void permissionR(File file);

    protected abstract void permissionRWX(File file);

    private static class Java6Chmod extends CommandLineUtils {
        @SuppressWarnings("ResultOfMethodCallIgnored")
        @SuppressLint("SetWorldReadable")
        @Override
        protected void permissionR(File file) {
            file.setReadable(true, false);
        }

        @SuppressWarnings("ResultOfMethodCallIgnored")
        @SuppressLint({"SetWorldReadable", "SetWorldWritable"})
        @Override
        protected void permissionRWX(File file) {
            file.setReadable(true, false);
            file.setWritable(true, false);
            file.setExecutable(true, false);
        }
    }
}
