package com.applovin.sdk;

/**
 * Created by Thomas So on October 02 2018
 * <p>
 * Object containing various flags related to the SDK configuration.
 */
public interface AppLovinSdkConfiguration
{
    /**
     * This enum represents whether or not the consent dialog should be shown for this user.
     * The state where no such determination could be made is represented by {@link ConsentDialogState#UNKNOWN}.
     */
    enum ConsentDialogState
    {
        /**
         * The consent dialog state could not be determined. This is likely due to SDK failing to initialize.
         */
        UNKNOWN,

        /**
         * This user should be shown a consent dialog.
         */
        APPLIES,

        /**
         * This user should not be shown a consent dialog.
         */
        DOES_NOT_APPLY
    }

    /**
     * Get the consent dialog state for this user. If no such determination could be made, {@link ConsentDialogState#UNKNOWN} will be returned.
     */
    ConsentDialogState getConsentDialogState();

    /**
     * Get the country code for this user. Returns an empty string if not available.
     */
    String getCountryCode();
}
