package com.applovin.mediation;

/**
 * Created by Thomas So on May 08 2021
 * <p>
 * This class encapsulates various data for MAX load and display errors.
 */
public interface MaxError
{
    /**
     * The error code for the error. Will be one of the codes listed in {@link MaxErrorCode}.
     */
    int getCode();

    /**
     * The error message for the error.
     */
    String getMessage();

    /**
     * The underlying waterfall of ad responses.
     */
    MaxAdWaterfallInfo getWaterfall();

    /**
     * @deprecated The ad load failure info string is deprecated and removed in a future SDK version. Please use {@code MaxError#getWaterfall} instead.
     */
    @Deprecated
    String getAdLoadFailureInfo();
}
