package com.applovin.sdk;

import java.util.Map;

/**
 * Class containing constants for use with {@link AppLovinEventService#trackEvent(String, Map)}.
 */
public class AppLovinEventParameters
{
    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents the username or account ID of the user. All keys and values in the parameter map should be of type String.
     */
    public static final String USER_ACCOUNT_IDENTIFIER = "username";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which identifies a particular piece of content viewed by the user. All keys and values in the parameter map should be of type String.
     * <p>
     * This could be something like a section title, or even a name of an activity. For views of particular products, it is preferred you pass an SKU under PRODUCT_IDENTIFIER.
     */
    public static final String CONTENT_IDENTIFIER = "content_id";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents a search query executed by the user. All keys and values in the parameter map should be of type String.
     */
    public static final String SEARCH_QUERY = "query";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents an identifier of the level the user has just completed. All keys and values in the parameter map should be of type String.
     */
    public static final String COMPLETED_LEVEL_IDENTIFIER = "level_id";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents an identifier of the achievement the user has just completed/unlocked. All keys and values in the parameter map should be of type String.
     */
    public static final String COMPLETED_ACHIEVEMENT_IDENTIFIER = "achievement_id";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents the amount of virtual currency that a user spent on an in-game purchase. All keys and values in the parameter map should be of type String.
     */
    public static final String VIRTUAL_CURRENCY_AMOUNT = "vcamount";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents the name of the virtual currency that a user spent on an in-game purchase. All keys and values in the parameter map should be of type String.
     */
    public static final String VIRTUAL_CURRENCY_NAME = "vcname";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which identifies a Google Play In-app Billing transaction ID. All keys and values in the parameter map should be of type String.
     */
    public static final String IN_APP_PURCHASE_TRANSACTION_IDENTIFIER = "store_id";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which identifiers Google Play In-app Billing purchase data. This should be the value for key IN_APP_PURCHASE_DATA in your IAP buy intent. All keys and values in the parameter map should be of type String.
     */
    public static final String IN_APP_PURCHASE_DATA = "receipt_data";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which identifiers Google Play In-app Billing purchase data. This should be the value for key IN_APP_DATA_SIGNATURE in your IAP buy intent. All keys and values in the parameter map should be of type String.
     */
    public static final String IN_APP_DATA_SIGNATURE = "receipt_data_signature";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which identifies a particular product. All keys and values in the parameter map should be of type String.
     * <p>
     * This could be something like a product name, SKU or inventory ID. For non-product content, like tracking uses of particular activities, it is preferred you pass CONTENT_IDENTIFIER instead.
     */
    public static final String PRODUCT_IDENTIFIER = "sku";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents the amount of revenue generated by a purchase event. All keys and values in the parameter map should be of type String.
     */
    public static final String REVENUE_AMOUNT = "amount";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents the currency of the revenue event. All keys and values in the parameter map should be of type String.
     * <p>
     * Ideally this should be an ISO 4217 3-letter currency code (for instance, USD, EUR, GBP...)
     */
    public static final String REVENUE_CURRENCY = "currency";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents a unique ID for the given checkout. All keys and values in the parameter map should be of type String.
     */
    public static final String CHECKOUT_TRANSACTION_IDENTIFIER = "transaction_id";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents the start date of a reservation. All keys and values in the parameter map should be of type String.
     */
    public static final String RESERVATION_START_TIMESTAMP = "start_date";

    /**
     * Parameter map key for {@link AppLovinEventService#trackEvent(String, Map)} which represents the end date of a reservation. All keys and values in the parameter map should be of type String.
     * <p>
     * If a reservation does not span multiple days, you can submit only RESERVATION_START_TIMESTAMP and ignore this parameter.
     */
    public static final String RESERVATION_END_TIMESTAMP = "end_date";
}
