package com.applovin.sdk;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Thomas So on October 02 2018
 * <p>
 * Object containing various flags related to the SDK configuration.
 */
public interface AppLovinSdkConfiguration
{
    /**
     * Get the country code for this user. Returns an empty string if not available.
     */
    String getCountryCode();

    /**
     * Get the list of those Ad Unit IDs that are in the waterfall that is currently active for a particular user and
     * for which Amazon Publisher Services is enabled.
     *
     * Which waterfall is currently active for a user depends on things like A/B tests, keyword targeting, or DNT.
     *
     * @return {@code null} when configuration fetching fails (e.g. in the case of no connection) or
     * an empty list if no Ad Unit IDs have Amazon Publisher Services enabled.
     */
    @Nullable
    List<String> getEnabledAmazonAdUnitIds();

    /**
     * Whether or not test mode is enabled for this session.
     *
     * @return {@code true} in one of the following cases:
     * <ul>
     * <li> 1. {@link com.applovin.sdk.AppLovinSdkSettings#setTestDeviceAdvertisingIds(List)} was called with current device's GAID prior to SDK initialization.</li>
     * <li> 2. Current device was registered as a test device through MAX dashboard -> MAX Test Devices prior to SDK initialization.</li>
     * <li> 3. Test mode was manually enabled for this session through the Mediation Debugger during the last session.</li>
     * <li> 4. Current device is an emulator.</li>
     * </ul>
     */
    boolean isTestModeEnabled();

    /**
     * @deprecated This API has been deprecated and will be removed in a future release.
     */
    @Deprecated
    enum ConsentDialogState
    {
        UNKNOWN,
        APPLIES,
        DOES_NOT_APPLY
    }

    /**
     * @deprecated This API has been deprecated and will be removed in a future release.
     */
    @Deprecated
    ConsentDialogState getConsentDialogState();
}
