/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.content.Context;
import android.net.Uri;
import com.applovin.impl.sdk.AppLovinSdkImpl;
import com.applovin.impl.sdk.ac;
import com.applovin.impl.sdk.ae;
import com.applovin.impl.sdk.ee;
import com.applovin.impl.sdk.gh;
import com.applovin.sdk.AppLovinLogger;
import com.applovin.sdk.AppLovinSdk;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class az {
    private final String a = "FileManager";
    private final AppLovinSdkImpl b;
    private final AppLovinLogger c;
    private final Object d;

    az(AppLovinSdk appLovinSdk) {
        this.b = (AppLovinSdkImpl)appLovinSdk;
        this.c = appLovinSdk.getLogger();
        this.d = new Object();
    }

    protected boolean a(Context context) {
        if (ae.a("android.permission.WRITE_EXTERNAL_STORAGE", context)) {
            return true;
        }
        if (ae.f() && !this.b.get(ee.cc).booleanValue()) {
            return true;
        }
        this.b.getLogger().w("FileManager", "Application lacks required WRITE_EXTERNAL_STORAGE manifest permission.");
        return false;
    }

    private File e(Context context) {
        File file = this.a(context) ? new File(context.getExternalFilesDir(null), "al") : new File(context.getCacheDir(), "al");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File a(String string, Context context, boolean bl2) {
        if (!gh.isValidString(string)) {
            this.b.getLogger().d("FileManager", "Nothing to look up, skipping...");
            return null;
        }
        this.c.d("FileManager", "Looking up cached resource: " + string);
        boolean bl3 = this.a(context);
        if (!bl3 && !bl2) {
            return null;
        }
        String string2 = string.contains("icon") ? string.replace("/", "_").replace(".", "_") : string;
        Object object = this.d;
        synchronized (object) {
            File file = this.e(context);
            File file2 = new File(file, string2);
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                return null;
            }
            return file2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> b(Context context) {
        File file = this.e(context);
        if (file.isDirectory()) {
            Object object = this.d;
            synchronized (object) {
                return Arrays.asList(file.listFiles());
            }
        }
        return new ArrayList<File>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean b(String string, Context context, boolean bl2) {
        Object object = this.d;
        synchronized (object) {
            File file = this.a(string, context, bl2);
            return file != null && file.exists() && !file.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean a(String string, Context context) {
        Object object = this.d;
        synchronized (object) {
            return this.b(string, context, false);
        }
    }

    boolean c(Context context) {
        if (this.b.get(ee.cd).booleanValue()) {
            try {
                this.a(".nomedia", context, false);
                File file = new File(this.e(context), ".nomedia");
                if (file != null) {
                    if (file.exists()) {
                        return true;
                    }
                    this.b.getLogger().d("FileManager", "Dropping .nomedia file at " + file.getAbsolutePath());
                    return file.createNewFile();
                }
            }
            catch (Exception exception) {
                this.b.getLogger().w("FileManager", "Failed to create nomedia file", exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ByteArrayOutputStream a(File file) {
        if (file == null) {
            return null;
        }
        this.c.d("FileManager", "Reading resource from filesystem: " + file.getName());
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Object object = this.d;
        synchronized (object) {
            ByteArrayOutputStream byteArrayOutputStream2;
            try {
                int n2;
                fileInputStream = new FileInputStream(file);
                byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n2 = fileInputStream.read(byArray, 0, byArray.length)) >= 0) {
                    try {
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    catch (Exception exception) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        ByteArrayOutputStream byteArrayOutputStream3 = null;
                        try {
                            if (fileInputStream == null) return byteArrayOutputStream3;
                            fileInputStream.close();
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                        return byteArrayOutputStream3;
                    }
                }
                byteArrayOutputStream2 = byteArrayOutputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.c.i("FileManager", "File not found. " + fileNotFoundException);
                ByteArrayOutputStream byteArrayOutputStream4 = null;
                return byteArrayOutputStream4;
            }
            catch (IOException iOException) {
                this.c.d("FileManager", "Failed to read file: " + file.getName() + iOException);
                ByteArrayOutputStream byteArrayOutputStream5 = null;
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                return byteArrayOutputStream5;
                catch (Throwable throwable) {
                    this.c.e("FileManager", "Unknown failure to read file.", throwable);
                    ByteArrayOutputStream byteArrayOutputStream6 = null;
                    try {
                        if (fileInputStream == null) return byteArrayOutputStream6;
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return byteArrayOutputStream6;
                }
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            return byteArrayOutputStream2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b(ByteArrayOutputStream byteArrayOutputStream, File file) {
        this.c.d("FileManager", "Writing resource to filesystem: " + file.getName());
        FileOutputStream fileOutputStream = null;
        boolean bl2 = false;
        Object object = this.d;
        synchronized (object) {
            try {
                fileOutputStream = new FileOutputStream(file);
                byteArrayOutputStream.writeTo(fileOutputStream);
                bl2 = true;
            }
            catch (IOException iOException) {
                this.c.e("FileManager", "Unable to write data to file.", iOException);
            }
            catch (Throwable throwable) {
                this.c.e("FileManager", "Unknown failure to write file.", throwable);
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b(File file) {
        boolean bl2;
        this.c.d("FileManager", "Removing file " + file.getName() + " from filesystem...");
        Object object = this.d;
        synchronized (object) {
            try {
                bl2 = file.delete();
            }
            catch (Exception exception) {
                this.c.e("FileManager", "Failed to remove file " + file.getName() + " from filesystem!", exception);
                return false;
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void d(Context context) {
        block6: {
            try {
                if (!this.a()) break block6;
                if (!this.b.e()) {
                    this.c.e("FileManager", "Cannot empty file cache after SDK has completed initialization and ad loads are in progress!");
                    break block6;
                }
                this.c.d("FileManager", "Compacting cache...");
                Object object = this.d;
                synchronized (object) {
                    long l2 = this.f(context);
                    this.a(l2, context);
                }
            }
            catch (Exception exception) {
                this.c.e("FileManager", "Caught exception while compacting cache!", exception);
                this.b.getSettingsManager().a(ee.aY, false);
                this.b.getSettingsManager().a();
            }
        }
    }

    private boolean a() {
        return this.b.get(ee.aY);
    }

    private long b() {
        long l2 = this.b.get(ee.aZ);
        if (l2 >= 0L && this.a()) {
            return l2;
        }
        return -1L;
    }

    private int c() {
        int n2 = this.b.get(ee.ba);
        if (n2 >= 0 && this.a()) {
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long f(Context context) {
        long l2 = 0L;
        long l3 = this.b();
        boolean bl2 = l3 != -1L;
        long l4 = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        Object object = this.d;
        synchronized (object) {
            for (File file : this.b(context)) {
                long l5;
                long l6;
                boolean bl3 = false;
                if (bl2 && (l6 = l4 - (l5 = TimeUnit.MILLISECONDS.toSeconds(file.lastModified()))) > l3) {
                    this.c.d("FileManager", "File " + file.getName() + " has expired, removing...");
                    this.b(file);
                    bl3 = true;
                }
                if (bl3) {
                    this.b.a().a("cached_files_expired");
                    continue;
                }
                l5 = file.length();
                l2 += l5;
            }
        }
        return l2;
    }

    private void a(long l2, Context context) {
        long l3 = this.c();
        if (l3 == -1L) {
            this.c.d("FileManager", "Cache has no maximum size set; skipping drop...");
        } else {
            long l4 = this.a(l2);
            if (l4 > l3) {
                this.c.d("FileManager", "Cache has exceeded maximum size; dropping...");
                this.g(context);
                this.b.a().a("cache_drop_count");
            } else {
                this.c.d("FileManager", "Cache is present but under size limit; not dropping...");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void g(Context context) {
        Object object = this.d;
        synchronized (object) {
            for (File file : this.b(context)) {
                this.b(file);
            }
        }
    }

    private long a(long l2) {
        return l2 / 0x100000L;
    }

    boolean a(File file, String string, List<String> list, ac ac2) {
        return this.a(file, string, list, true, ac2);
    }

    boolean a(File file, String string, List<String> list, boolean bl2, ac ac2) {
        if (file != null && file.exists() && !file.isDirectory()) {
            this.b.getLogger().d("FileManager", "File exists for " + string);
            if (ac2 != null) {
                ac2.b(file.length());
            }
            return true;
        }
        ByteArrayOutputStream byteArrayOutputStream = this.a(string, list, bl2);
        if (ac2 != null) {
            ac2.a(byteArrayOutputStream.size());
        }
        return this.a(byteArrayOutputStream, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteArrayOutputStream a(String string, List<String> list, boolean bl2) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (bl2 && !gh.a(string, list)) {
            this.c.d("FileManager", "Domain is not whitelisted, skipping precache for url: " + string);
            return null;
        }
        if (this.b.get(ee.bS).booleanValue() && !string.contains("https://")) {
            this.b.getLogger().w("FileManager", "Plaintext HTTP operation requested; upgrading to HTTPS due to universal SSL setting...");
            string = string.replace("http://", "https://");
        }
        this.c.d("FileManager", "Loading " + string + "...");
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        InputStream inputStream = null;
        HttpURLConnection httpURLConnection = null;
        try {
            int n2;
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(this.b.get(ee.w));
            httpURLConnection.setReadTimeout(this.b.get(ee.y));
            httpURLConnection.setDefaultUseCaches(true);
            httpURLConnection.setUseCaches(true);
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setInstanceFollowRedirects(true);
            int n3 = httpURLConnection.getResponseCode();
            if (n3 < 200 || n3 >= 300) {
                ByteArrayOutputStream byteArrayOutputStream3 = null;
                return byteArrayOutputStream3;
            }
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                try {
                    byteArrayOutputStream2.write(byArray, 0, n2);
                }
                catch (Exception exception) {
                    try {
                        byteArrayOutputStream2.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    ByteArrayOutputStream byteArrayOutputStream4 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    try {
                        if (byteArrayOutputStream2 != null) {
                            byteArrayOutputStream2.close();
                        }
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                    try {
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                    return byteArrayOutputStream4;
                }
            }
            this.c.d("FileManager", "Loaded resource at " + string);
            byteArrayOutputStream = byteArrayOutputStream2;
        }
        catch (IOException iOException) {
            this.c.e("FileManager", "Error loading " + string, iOException);
            ByteArrayOutputStream byteArrayOutputStream5 = null;
            return byteArrayOutputStream5;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (byteArrayOutputStream2 != null) {
                    byteArrayOutputStream2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception) {}
        }
        return byteArrayOutputStream;
    }

    boolean a(ByteArrayOutputStream byteArrayOutputStream, File file) {
        if (file == null) {
            return false;
        }
        this.c.d("FileManager", "Caching " + file.getAbsolutePath() + "...");
        if (byteArrayOutputStream != null && byteArrayOutputStream.size() > 0) {
            boolean bl2 = this.b(byteArrayOutputStream, file);
            if (!bl2) {
                this.c.e("FileManager", "Unable to cache " + file.getAbsolutePath());
                return false;
            }
            this.c.d("FileManager", "Caching completed for " + file);
            return true;
        }
        this.c.w("FileManager", "No data for " + file.getAbsolutePath());
        return false;
    }

    String a(Context context, String string, String string2, List<String> list, boolean bl2, ac ac2) throws MalformedURLException {
        return this.a(context, string, string2, list, bl2, false, ac2);
    }

    String a(Context context, String string, String string2, List<String> list, boolean bl2, boolean bl3, ac ac2) throws MalformedURLException {
        File file;
        boolean bl4;
        if (!gh.isValidString(string)) {
            this.b.getLogger().d("FileManager", "Nothing to cache, skipping...");
            return null;
        }
        Uri uri = Uri.parse((String)string);
        String string3 = uri.getLastPathSegment();
        if (gh.isValidString(string3) && gh.isValidString(string2)) {
            string3 = string2 + string3;
        }
        if (bl4 = this.a(file = this.a(string3, context, false), string, list, bl2, ac2)) {
            this.c.d("FileManager", "Caching succeeded for file " + string3);
            return bl3 ? Uri.fromFile((File)file).toString() : string3;
        }
        return null;
    }
}

