/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import com.applovin.impl.sdk.ad;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class AppLovinAdSize {
    public static final int SPAN = -1;
    public static final AppLovinAdSize BANNER = new AppLovinAdSize(-1, 50, "BANNER");
    public static final AppLovinAdSize LEADER = new AppLovinAdSize(-1, 75, "LEADER");
    public static final AppLovinAdSize INTERSTITIAL = new AppLovinAdSize(-1, -1, "INTER");
    public static final AppLovinAdSize MREC = new AppLovinAdSize(300, 250, "MREC");
    public static final AppLovinAdSize NATIVE = new AppLovinAdSize("NATIVE");
    private final int a;
    private final int b;
    private final String c;

    public AppLovinAdSize(String string) {
        this(0, 0, string);
    }

    protected AppLovinAdSize(int n2, int n3, String string) {
        if (n2 < 0 && n2 != -1) {
            throw new IllegalArgumentException("Ad width must be a positive number. Number provided: " + n2);
        }
        if (n2 > 9999) {
            throw new IllegalArgumentException("Ad width must be less then 9999. Number provided: " + n2);
        }
        if (n3 < 0 && n3 != -1) {
            throw new IllegalArgumentException("Ad height must be a positive number. Number provided: " + n3);
        }
        if (n3 > 9999) {
            throw new IllegalArgumentException("Ad height must be less then 9999. Number provided: " + n3);
        }
        if (string == null) {
            throw new IllegalArgumentException("No label specified");
        }
        if (string.length() > 9) {
            throw new IllegalArgumentException("Provided label is too long. Label provided: " + string);
        }
        this.a = n2;
        this.b = n3;
        this.c = string;
    }

    public int getWidth() {
        return this.a;
    }

    public int getHeight() {
        return this.b;
    }

    public String getLabel() {
        return this.c.toUpperCase(Locale.ENGLISH);
    }

    public String toString() {
        return this.getLabel();
    }

    public static AppLovinAdSize fromString(String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals("banner")) {
            return BANNER;
        }
        if (string2.equals("interstitial") || string2.equals("inter")) {
            return INTERSTITIAL;
        }
        if (string2.equals("mrec")) {
            return MREC;
        }
        if (string2.equals("leader")) {
            return LEADER;
        }
        List<String> list = ad.a(string, "x");
        if (list.size() == 2) {
            int n2 = AppLovinAdSize.a(list.get(0));
            int n3 = AppLovinAdSize.a(list.get(1));
            return new AppLovinAdSize(n2, n3, string);
        }
        return new AppLovinAdSize(0, 0, string);
    }

    private static int a(String string) {
        if ("span".equalsIgnoreCase(string)) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static Set<AppLovinAdSize> allSizes() {
        HashSet<AppLovinAdSize> hashSet = new HashSet<AppLovinAdSize>(4);
        hashSet.add(BANNER);
        hashSet.add(MREC);
        hashSet.add(INTERSTITIAL);
        hashSet.add(LEADER);
        hashSet.add(NATIVE);
        return hashSet;
    }
}

