/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.util.Log;
import com.applovin.impl.sdk.AppLovinInternalSdkSettings;
import com.applovin.impl.sdk.AppLovinSdkImpl;
import com.applovin.nativeAds.AppLovinNativeAdService;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinEventService;
import com.applovin.sdk.AppLovinLogger;
import com.applovin.sdk.AppLovinMediationService;
import com.applovin.sdk.AppLovinPostbackService;
import com.applovin.sdk.AppLovinSdkSettings;
import com.applovin.sdk.AppLovinSdkUtils;

public abstract class AppLovinSdk {
    public static final String VERSION = "8.1.0";
    public static final int VERSION_CODE = 810;
    public static final String URI_SCHEME = "applovin";
    public static final String URI_HOST = "com.applovin.sdk";
    protected static AppLovinSdkImpl[] sdkInstances = new AppLovinSdkImpl[0];
    protected static final Object sdkInstancesLock = new Object();

    public abstract String getSdkKey();

    public abstract void setPluginVersion(String var1);

    public abstract void setMediationProvider(String var1);

    public abstract String getMediationProvider();

    public abstract AppLovinSdkSettings getSettings();

    public abstract boolean isEnabled();

    public abstract boolean hasCriticalErrors();

    public abstract AppLovinAdService getAdService();

    public abstract AppLovinNativeAdService getNativeAdService();

    public abstract AppLovinPostbackService getPostbackService();

    public abstract AppLovinEventService getEventService();

    public abstract AppLovinMediationService getMediationService();

    public abstract void setUserIdentifier(String var1);

    public abstract String getUserIdentifier();

    public abstract void initializeSdk();

    public abstract Context getApplicationContext();

    public abstract AppLovinLogger getLogger();

    public abstract void initialize(String var1, AppLovinSdkSettings var2, Context var3);

    public static void initializeSdk(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        AppLovinSdk appLovinSdk = AppLovinSdk.getInstance(context);
        if (appLovinSdk != null) {
            appLovinSdk.initializeSdk();
        } else {
            Log.e((String)"AppLovinSdk", (String)"Unable to initialize AppLovin SDK: SDK object not created");
        }
    }

    public static AppLovinSdk getInstance(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        String string = AppLovinSdkUtils.retrieveSdkKey(context);
        return AppLovinSdk.getInstance(string, new AppLovinInternalSdkSettings(context), context);
    }

    public static AppLovinSdk getInstance(AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        String string = AppLovinSdkUtils.retrieveSdkKey(context);
        return AppLovinSdk.getInstance(string, appLovinSdkSettings, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppLovinSdk getInstance(String string, AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (appLovinSdkSettings == null) {
            throw new IllegalArgumentException("No userSettings specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        Object object = sdkInstancesLock;
        synchronized (object) {
            AppLovinSdkImpl[] appLovinSdkImplArray;
            AppLovinSdkImpl[] throwable;
            if (sdkInstances.length == 1 && sdkInstances[0].getSdkKey().equals(string)) {
                return sdkInstances[0];
            }
            for (AppLovinSdkImpl appLovinSdkImpl : sdkInstances) {
                if (!((AppLovinSdk)appLovinSdkImpl).getSdkKey().equals(string)) continue;
                return appLovinSdkImpl;
            }
            try {
                throwable = new AppLovinSdkImpl();
                throwable.initialize(string, appLovinSdkSettings, context);
                throwable.setInitializedInMainActivity(throwable.checkCorrectInitialization(context));
                appLovinSdkImplArray = throwable;
            }
            catch (Throwable throwable2) {
                Log.e((String)"AppLovinSdk", (String)"Failed to build AppLovin SDK. Try cleaning application data and starting the application again.", (Throwable)throwable2);
                throw new RuntimeException("Unable to build AppLovin SDK");
            }
            throwable = new AppLovinSdkImpl[sdkInstances.length + 1];
            System.arraycopy(sdkInstances, 0, throwable, 0, sdkInstances.length);
            throwable[AppLovinSdk.sdkInstances.length] = appLovinSdkImplArray;
            sdkInstances = throwable;
            return appLovinSdkImplArray;
        }
    }
}

