/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import com.applovin.impl.sdk.AppLovinSdkImpl;
import com.applovin.impl.sdk.gh;
import java.io.File;

public class AppLovinSdkUtils {
    public static final String TAG = "AppLovinSdkUtils";
    private static final Handler a = new Handler(Looper.getMainLooper());

    public static String retrieveSdkKey(Context context) {
        Bundle bundle = gh.d(context);
        if (bundle != null) {
            String string = bundle.getString("applovin.sdk.key");
            return string != null ? string : "";
        }
        return null;
    }

    public static int dpToPx(Context context, int n2) {
        return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static void safePopulateImageView(ImageView imageView, Uri uri, int n2) {
        AppLovinSdkUtils.recycleImageView(imageView);
        File file = new File(uri.getPath());
        Bitmap bitmap = gh.a(file, n2);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void safePopulateImageView(Context context, ImageView imageView, int n2, int n3) {
        AppLovinSdkUtils.recycleImageView(imageView);
        Bitmap bitmap = gh.a(context, n2, n3);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void safePopulateImageView(ImageView imageView, Bitmap bitmap) {
        AppLovinSdkUtils.recycleImageView(imageView);
        if (imageView != null && bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void recycleImageView(ImageView imageView) {
        Drawable drawable;
        if (imageView != null && (drawable = imageView.getDrawable()) != null && drawable instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable;
            Bitmap bitmap = bitmapDrawable.getBitmap();
            bitmap.recycle();
        }
    }

    public static boolean openUri(Context context, Uri uri, AppLovinSdkImpl appLovinSdkImpl) {
        boolean bl2 = false;
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (!(context instanceof Activity)) {
                intent.setFlags(0x10000000);
            }
            appLovinSdkImpl.getSessionTracker().a();
            context.startActivity(intent);
            bl2 = true;
        }
        catch (Throwable throwable) {
            appLovinSdkImpl.getLogger().e(TAG, "Unable to open \"" + uri + "\".", throwable);
        }
        if (!bl2) {
            appLovinSdkImpl.getSessionTracker().b();
        }
        return bl2;
    }

    public static boolean isValidString(String string) {
        return string != null && string.length() > 1;
    }

    public static boolean isLocalFile(Uri uri) {
        return uri != null && "file".equalsIgnoreCase(uri.getScheme());
    }

    public static void runOnUiThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            a.post(runnable);
        }
    }
}

