/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.compiler;

import com.arialyy.annotations.Download;
import com.arialyy.annotations.DownloadGroup;
import com.arialyy.annotations.TaskEnum;
import com.arialyy.annotations.Upload;
import com.arialyy.compiler.EntityInfo;
import com.arialyy.compiler.MethodInfo;
import com.arialyy.compiler.ParamObtainUtil;
import com.arialyy.compiler.ProxyClassParam;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;

final class EventProxyFiler {
    private Filer mFiler;
    private ParamObtainUtil mPbUtil;

    EventProxyFiler(Filer filer, ParamObtainUtil pbUtil) {
        this.mFiler = filer;
        this.mPbUtil = pbUtil;
    }

    void createEventProxyFile() throws IOException {
        Set<String> keys = this.mPbUtil.getMethodParams().keySet();
        for (String key : keys) {
            ProxyClassParam entity = this.mPbUtil.getMethodParams().get(key);
            JavaFile jf = JavaFile.builder((String)entity.packageName, (TypeSpec)this.createProxyClass(entity)).build();
            this.createFile(jf);
        }
    }

    private MethodSpec createM3U8PeerMethod(TaskEnum taskEnum, Class<? extends Annotation> annotation, MethodInfo methodInfo) {
        String sb = String.format("obj.%s(m3u8Url, peerPath, peerIndex);\n", methodInfo.methodName);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)annotation.getSimpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addParameter(String.class, "m3u8Url", new Modifier[]{Modifier.FINAL}).addParameter(String.class, "peerPath", new Modifier[]{Modifier.FINAL}).addParameter(Integer.TYPE, "peerIndex", new Modifier[]{Modifier.FINAL}).addAnnotation(Override.class).addCode(sb, new Object[0]);
        return builder.build();
    }

    private MethodSpec createTaskMethod(TaskEnum taskEnum, Class<? extends Annotation> annotation, MethodInfo methodInfo) {
        ClassName task = ClassName.get((String)taskEnum.pkg, (String)taskEnum.className, (String[])new String[0]);
        String callCode = taskEnum == TaskEnum.DOWNLOAD_GROUP_SUB ? (methodInfo.params.get(methodInfo.params.size() - 1).asType().toString().equals(Exception.class.getName()) && annotation == DownloadGroup.onSubTaskFail.class ? "task, subEntity, e" : "task, subEntity") : (methodInfo.params.get(methodInfo.params.size() - 1).asType().toString().equals(Exception.class.getName()) && (annotation == Download.onTaskFail.class || annotation == Upload.onTaskFail.class || annotation == DownloadGroup.onTaskFail.class) ? "task, e" : "task");
        String sb = String.format("obj.%s((%s)%s);\n", methodInfo.methodName, taskEnum.className, callCode);
        ParameterSpec taskParam = ParameterSpec.builder((TypeName)task, (String)"task", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)annotation.getSimpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addParameter(taskParam).addAnnotation(Override.class).addCode(sb, new Object[0]);
        if (taskEnum == TaskEnum.DOWNLOAD_GROUP_SUB) {
            ClassName subTask = ClassName.get((String)EntityInfo.DOWNLOAD.pkg, (String)EntityInfo.DOWNLOAD.className, (String[])new String[0]);
            ParameterSpec subTaskParam = ParameterSpec.builder((TypeName)subTask, (String)"subEntity", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
            builder.addParameter(subTaskParam);
        }
        if (annotation == Download.onTaskFail.class || annotation == Upload.onTaskFail.class || annotation == DownloadGroup.onTaskFail.class || annotation == DownloadGroup.onSubTaskFail.class) {
            ParameterSpec exception = ParameterSpec.builder(Exception.class, (String)"e", (Modifier[])new Modifier[0]).build();
            builder.addParameter(exception);
        }
        return builder.build();
    }

    private TypeSpec createProxyClass(ProxyClassParam entity) {
        ClassName taskTypeVariable;
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)entity.proxyClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        ClassName obj = ClassName.get((String)entity.packageName, (String)entity.className, (String[])new String[0]);
        FieldSpec observerField = FieldSpec.builder((TypeName)obj, (String)"obj", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        builder.addField(observerField);
        for (TaskEnum te : entity.methods.keySet()) {
            Map<Class<? extends Annotation>, MethodInfo> methodInfoMap = entity.methods.get(te);
            if (methodInfoMap == null) continue;
            for (Class<? extends Annotation> annotation : methodInfoMap.keySet()) {
                MethodSpec method;
                if (te == TaskEnum.DOWNLOAD || te == TaskEnum.DOWNLOAD_GROUP || te == TaskEnum.DOWNLOAD_GROUP_SUB || te == TaskEnum.UPLOAD) {
                    method = this.createTaskMethod(te, annotation, methodInfoMap.get(annotation));
                    builder.addMethod(method);
                    continue;
                }
                if (te != TaskEnum.M3U8_PEER) continue;
                method = this.createM3U8PeerMethod(te, annotation, methodInfoMap.get(annotation));
                builder.addMethod(method);
            }
        }
        MethodSpec structure = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        builder.addMethod(structure);
        ParameterSpec parameterSpec = ParameterSpec.builder(Object.class, (String)"obj", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        MethodSpec listener = MethodSpec.methodBuilder((String)"setListener").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addParameter(parameterSpec).addAnnotation(Override.class).addCode("this.obj = (" + entity.className + ")obj;\n", new Object[0]).build();
        builder.addJavadoc("\u8be5\u6587\u4ef6\u4e3aAria\u81ea\u52a8\u751f\u6210\u7684\u4ee3\u7406\u6587\u4ef6\uff0c\u8bf7\u4e0d\u8981\u4fee\u6539\u8be5\u6587\u4ef6\u7684\u4efb\u4f55\u4ee3\u7801\uff01\n", new Object[0]);
        ClassName superClass = ClassName.get((String)"com.arialyy.aria.core.scheduler", (String)entity.mainTaskEnum.proxySuperClass, (String[])new String[0]);
        if (entity.mainTaskEnum == TaskEnum.DOWNLOAD || entity.mainTaskEnum == TaskEnum.UPLOAD || entity.mainTaskEnum == TaskEnum.DOWNLOAD_GROUP) {
            taskTypeVariable = ClassName.get((String)entity.mainTaskEnum.pkg, (String)entity.mainTaskEnum.className, (String[])new String[0]);
            builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)superClass, (TypeName[])new TypeName[]{taskTypeVariable}));
        } else if (entity.mainTaskEnum == TaskEnum.DOWNLOAD_GROUP_SUB) {
            taskTypeVariable = ClassName.get((String)entity.mainTaskEnum.pkg, (String)entity.mainTaskEnum.className, (String[])new String[0]);
            ClassName subTaskTypeVariable = ClassName.get((String)entity.subTaskEnum.pkg, (String)entity.subTaskEnum.className, (String[])new String[0]);
            builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)superClass, (TypeName[])new TypeName[]{taskTypeVariable, subTaskTypeVariable}));
        } else if (entity.mainTaskEnum == TaskEnum.M3U8_PEER) {
            builder.superclass((TypeName)superClass);
        }
        builder.addMethod(listener);
        return builder.build();
    }

    private void createFile(JavaFile jf) throws IOException {
        jf.writeTo(this.mFiler);
    }
}

