/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.compiler;

import com.arialyy.annotations.Download;
import com.arialyy.annotations.DownloadGroup;
import com.arialyy.annotations.TaskEnum;
import com.arialyy.annotations.Upload;
import com.arialyy.compiler.EntityInfo;
import com.arialyy.compiler.MethodInfo;
import com.arialyy.compiler.ProxyClassParam;
import com.arialyy.compiler.ValuesUtil;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

class ParamObtainUtil {
    private Map<String, ProxyClassParam> mMethodParams = new HashMap<String, ProxyClassParam>();
    private Elements mElementUtil;

    ParamObtainUtil(Elements elements) {
        this.mElementUtil = elements;
    }

    Map<String, ProxyClassParam> getMethodParams() {
        return this.mMethodParams;
    }

    void saveMethod(TaskEnum taskEnum, RoundEnvironment roundEnv, Class<? extends Annotation> annotationClazz, int annotationType) {
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationClazz)) {
            ElementKind kind = element.getKind();
            if (kind != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element;
            TypeElement classElement = (TypeElement)method.getEnclosingElement();
            PackageElement packageElement = this.mElementUtil.getPackageOf(classElement);
            String methodName = method.getSimpleName().toString();
            String className = method.getEnclosingElement().toString();
            String key = className + taskEnum.proxySuffix;
            ProxyClassParam proxyEntity = this.mMethodParams.get(key);
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.methodName = methodName;
            methodInfo.params = method.getParameters();
            if (taskEnum == TaskEnum.M3U8_PEER) {
                this.checkM3U8PeerMethod(method, methodInfo.params);
            } else {
                this.checkTaskMethod(taskEnum, method, annotationClazz, methodInfo.params);
            }
            if (proxyEntity == null) {
                proxyEntity = new ProxyClassParam();
                proxyEntity.taskEnums = new HashSet<TaskEnum>();
                proxyEntity.packageName = packageElement.getQualifiedName().toString();
                proxyEntity.className = classElement.getSimpleName().toString();
                proxyEntity.proxyClassName = proxyEntity.className + taskEnum.proxySuffix;
                proxyEntity.mainTaskEnum = taskEnum;
                if (taskEnum == TaskEnum.DOWNLOAD_GROUP_SUB || taskEnum == TaskEnum.DOWNLOAD_GROUP) {
                    proxyEntity.subTaskEnum = EntityInfo.DOWNLOAD;
                }
                this.mMethodParams.put(key, proxyEntity);
            }
            proxyEntity.taskEnums.add(taskEnum);
            if (proxyEntity.methods.get(taskEnum) == null) {
                proxyEntity.methods.put(taskEnum, new HashMap());
            }
            proxyEntity.methods.get(taskEnum).put(annotationClazz, methodInfo);
            proxyEntity.keyMappings.put(methodName, this.getValues(taskEnum, method, annotationType));
        }
    }

    private Set<String> getValues(TaskEnum taskEnum, ExecutableElement method, int annotationType) {
        String[] keys = null;
        switch (taskEnum) {
            case DOWNLOAD: {
                keys = ValuesUtil.getDownloadValues(method, annotationType);
                break;
            }
            case UPLOAD: {
                keys = ValuesUtil.getUploadValues(method, annotationType);
                break;
            }
            case DOWNLOAD_GROUP: {
                keys = ValuesUtil.getDownloadGroupValues(method, annotationType);
                break;
            }
            case DOWNLOAD_GROUP_SUB: {
                keys = ValuesUtil.getDownloadGroupSubValues(method, annotationType);
                break;
            }
            case M3U8_PEER: {
                keys = ValuesUtil.getM3U8PeerValues(method, annotationType);
            }
        }
        return keys == null ? null : this.convertSet(keys);
    }

    private void checkM3U8PeerMethod(ExecutableElement method, List<VariableElement> params) {
        String methodName = method.getSimpleName().toString();
        String className = method.getEnclosingElement().toString();
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            throw new IllegalAccessError(String.format("%s.%s, \u4e0d\u80fd\u4e3aprivate\u65b9\u6cd5", className, methodName));
        }
        if (!(params.size() == 3 && params.get(0).asType().toString().equals(String.class.getName()) && params.get(1).asType().toString().equals(String.class.getName()) && params.get(2).asType().toString().equals("int"))) {
            throw new IllegalArgumentException(String.format("%s.%s \u7684\u53c2\u6570\u9519\u8bef\uff0c\u8be5\u65b9\u6cd5\u9700\u8981\u7684\u53c2\u6570\u4e3a\uff1aString, String, int", className, methodName));
        }
    }

    private void checkTaskMethod(TaskEnum taskEnum, ExecutableElement method, Class<? extends Annotation> annotationClazz, List<VariableElement> params) {
        String methodName = method.getSimpleName().toString();
        String className = method.getEnclosingElement().toString();
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            throw new IllegalAccessError(String.format("%s.%s, \u4e0d\u80fd\u4e3aprivate\u65b9\u6cd5", className, methodName));
        }
        if (taskEnum == TaskEnum.DOWNLOAD_GROUP_SUB) {
            if (this.isFailAnnotation(annotationClazz)) {
                if (params.size() < 2 || params.size() > 3) {
                    throw new IllegalArgumentException(String.format("%s.%s\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u53ea\u80fd\u662f\u4e24\u4e2a\u6216\u4e09\u4e2a\uff0c\u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e09\u4e2a\u53c2\u6570\uff08\u53ef\u9009\uff09\u662f\uff1a%s", className, methodName, this.getCheckParams(taskEnum), this.getCheckSubParams(taskEnum), Exception.class.getSimpleName()));
                }
                if (!(params.size() != 2 || params.get(0).asType().toString().equals(this.getCheckParams(taskEnum)) && params.get(1).asType().toString().equals(this.getCheckSubParams(taskEnum)))) {
                    throw new IllegalArgumentException(String.format("%s.%s\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u53ea\u80fd\u662f\u4e24\u4e2a\u6216\u4e09\u4e2a\uff0c\u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e09\u4e2a\u53c2\u6570\uff08\u53ef\u9009\uff09\u662f\uff1a%s", className, methodName, this.getCheckParams(taskEnum), this.getCheckSubParams(taskEnum), Exception.class.getSimpleName()));
                }
                if (!(params.size() != 3 || params.get(0).asType().toString().equals(this.getCheckParams(taskEnum)) && params.get(1).asType().toString().equals(this.getCheckSubParams(taskEnum)) && params.get(2).asType().toString().equals(Exception.class.getName()))) {
                    throw new IllegalArgumentException(String.format("%s.%s\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u53ea\u80fd\u662f\u4e24\u4e2a\u6216\u4e09\u4e2a\uff0c\u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e09\u4e2a\u53c2\u6570\uff08\u53ef\u9009\uff09\u662f\uff1a%s", className, methodName, this.getCheckParams(taskEnum), this.getCheckSubParams(taskEnum), Exception.class.getSimpleName()));
                }
            } else if (!(params.size() != 2 || params.get(0).asType().toString().equals(this.getCheckParams(taskEnum)) && params.get(1).asType().toString().equals(this.getCheckSubParams(taskEnum)))) {
                throw new IllegalArgumentException(String.format("%s.%s\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u53ea\u80fd\u662f\u4e24\u4e2a\u6216\u4e09\u4e2a\uff0c\u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\uff1a%s", className, methodName, this.getCheckParams(taskEnum), this.getCheckSubParams(taskEnum)));
            }
        } else if (this.isFailAnnotation(annotationClazz)) {
            if (params.size() < 1 || params.size() > 2) {
                throw new IllegalArgumentException(String.format("%s.%s\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u53ea\u80fd\u6709\u4e00\u4e2a\u6216\u4e24\u4e2a\uff0c\u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\uff08\u53ef\u9009\uff09\u662f\uff1a%s", className, methodName, this.getCheckParams(taskEnum), Exception.class.getSimpleName()));
            }
            if (params.size() == 1 && !params.get(0).asType().toString().equals(this.getCheckParams(taskEnum))) {
                throw new IllegalArgumentException(String.format("%s.%s\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u53ea\u80fd\u6709\u4e00\u4e2a\u6216\u4e24\u4e2a\uff0c\u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\uff08\u53ef\u9009\uff09\u662f\uff1a%s", className, methodName, this.getCheckParams(taskEnum), Exception.class.getSimpleName()));
            }
            if (!(params.size() != 2 || params.get(0).asType().toString().equals(this.getCheckParams(taskEnum)) && params.get(1).asType().toString().equals(Exception.class.getName()))) {
                throw new IllegalArgumentException(String.format("%s.%s\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u53ea\u80fd\u6709\u4e00\u4e2a\u6216\u4e24\u4e2a\uff0c\u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\uff1a%s\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\uff08\u53ef\u9009\uff09\u662f\uff1a%s", className, methodName, this.getCheckParams(taskEnum), Exception.class.getSimpleName()));
            }
        } else if (params.size() != 1 && !params.get(0).asType().toString().equals(this.getCheckParams(taskEnum))) {
            throw new IllegalArgumentException(String.format("%s.%s\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u53ea\u80fd\u6709\u4e00\u4e2a\uff0c\u4e14\u53c2\u6570\u5fc5\u987b\u662f\uff1a%s", className, methodName, this.getCheckParams(taskEnum)));
        }
    }

    private boolean isFailAnnotation(Class<? extends Annotation> annotationClazz) {
        return annotationClazz == Download.onTaskFail.class || annotationClazz == DownloadGroup.onTaskFail.class || annotationClazz == DownloadGroup.onSubTaskFail.class || annotationClazz == Upload.onTaskFail.class;
    }

    private Set<String> convertSet(String[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        if (keys[0].isEmpty()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, keys);
        return set;
    }

    private String getCheckParams(TaskEnum taskEnum) {
        return taskEnum.pkg + "." + taskEnum.className;
    }

    private String getCheckSubParams(TaskEnum taskEnum) {
        if (taskEnum == TaskEnum.DOWNLOAD_GROUP_SUB) {
            return EntityInfo.DOWNLOAD.pkg + "." + EntityInfo.DOWNLOAD.className;
        }
        return "";
    }
}

