/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import locus.api.objects.extra.Location;

public class LocationCompute {
    private Location loc;
    private double mLat1 = 0.0;
    private double mLon1 = 0.0;
    private double mLat2 = 0.0;
    private double mLon2 = 0.0;
    private final float[] mResults = new float[2];
    private static final double parWgs84AxisA = 6378137.0;
    private static final double parWgs84AxisB = 6356752.3142;
    private static final double parWgs84Flat = 0.0033528106718309896;
    public static final double AVERAGE_RADIUS_OF_EARTH = 6371000.0;
    private static double[] mDistResult = new double[1];

    public LocationCompute(Location loc) {
        this.loc = loc;
    }

    public static void computeDistanceAndBearing(double lat1, double lon1, double lat2, double lon2, float[] results) {
        LocationCompute.computeDistanceAndBearing(lat1, lon1, lat2, lon2, 6378137.0, 6356752.3142, 0.0033528106718309896, results);
    }

    public static void computeDistanceAndBearing(double lat1, double lon1, double lat2, double lon2, double a, double b, double f, float[] results) {
        float distance;
        int MAXITERS = 20;
        double aSqMinusBSqOverBSq = (a * a - b * b) / (b * b);
        double L = (lon2 *= Math.PI / 180) - (lon1 *= Math.PI / 180);
        double A = 0.0;
        double U1 = Math.atan((1.0 - f) * Math.tan(lat1 *= Math.PI / 180));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat2 *= Math.PI / 180));
        double cosU1 = Math.cos(U1);
        double cosU2 = Math.cos(U2);
        double sinU1 = Math.sin(U1);
        double sinU2 = Math.sin(U2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double cosLambda = 0.0;
        double sinLambda = 0.0;
        double lambda = L;
        for (int iter = 0; iter < MAXITERS; ++iter) {
            double lambdaOrig = lambda;
            cosLambda = Math.cos(lambda);
            sinLambda = Math.sin(lambda);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double sinSqSigma = t1 * t1 + t2 * t2;
            double sinSigma = Math.sqrt(sinSqSigma);
            double cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            double cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            double cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * aSqMinusBSqOverBSq;
            double A1 = uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
            A = 1.0 + A1;
            double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            double cos2SMSq = cos2SM * cos2SM;
            deltaSigma = B * sinSigma * (cos2SM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - B / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SM + C * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            double delta = (lambda - lambdaOrig) / lambda;
            if (Math.abs(delta) < 1.0E-12) break;
        }
        results[0] = distance = (float)(b * A * (sigma - deltaSigma));
        if (results.length > 1) {
            float initialBearing = (float)Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda);
            results[1] = initialBearing = (float)((double)initialBearing * 57.29577951308232);
            if (results.length > 2) {
                float finalBearing = (float)Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda);
                results[2] = finalBearing = (float)((double)finalBearing * 57.29577951308232);
            }
        }
    }

    public static void distanceBetween(double startLatitude, double startLongitude, double endLatitude, double endLongitude, float[] results) {
        if (results == null || results.length < 1) {
            throw new IllegalArgumentException("results is null or has length < 1");
        }
        LocationCompute.computeDistanceAndBearing(startLatitude, startLongitude, endLatitude, endLongitude, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float distanceTo(Location dest) {
        float[] fArray = this.mResults;
        synchronized (this.mResults) {
            if (this.loc.latitude != this.mLat1 || this.loc.longitude != this.mLon1 || dest.latitude != this.mLat2 || dest.longitude != this.mLon2) {
                LocationCompute.computeDistanceAndBearing(this.loc.latitude, this.loc.longitude, dest.latitude, dest.longitude, this.mResults);
                this.mLat1 = this.loc.latitude;
                this.mLon1 = this.loc.longitude;
                this.mLat2 = dest.latitude;
                this.mLon2 = dest.longitude;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mResults[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float bearingTo(Location dest) {
        float[] fArray = this.mResults;
        synchronized (this.mResults) {
            if (this.loc.latitude != this.mLat1 || this.loc.longitude != this.mLon1 || dest.latitude != this.mLat2 || dest.longitude != this.mLon2) {
                LocationCompute.computeDistanceAndBearing(this.loc.latitude, this.loc.longitude, dest.latitude, dest.longitude, this.mResults);
                this.mLat1 = this.loc.latitude;
                this.mLon1 = this.loc.longitude;
                this.mLat2 = dest.latitude;
                this.mLon2 = dest.longitude;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mResults[1];
        }
    }

    public static synchronized double computeDistanceFast(Location loc1, Location loc2) {
        LocationCompute.computeDistanceAndBearingFast(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude(), mDistResult);
        return mDistResult[0];
    }

    public static synchronized double computeDistanceFast(double lat1, double lon1, double lat2, double lon2) {
        LocationCompute.computeDistanceAndBearingFast(lat1, lon1, lat2, lon2, mDistResult);
        return mDistResult[0];
    }

    public static void computeDistanceAndBearingFast(double lat1, double lon1, double lat2, double lon2, double[] results) {
        double cosLat1 = Math.cos(lat1 *= Math.PI / 180);
        double cosLat2 = Math.cos(lat2 *= Math.PI / 180);
        double sinDLat2 = Math.sin((lat2 - lat1) / 2.0);
        double sinDLon2 = Math.sin(((lon2 *= Math.PI / 180) - (lon1 *= Math.PI / 180)) / 2.0);
        double a = sinDLat2 * sinDLat2 + cosLat1 * cosLat2 * sinDLon2 * sinDLon2;
        double d = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        results[0] = d * 6371000.0;
        if (results.length > 1) {
            double y = Math.sin(lon2 - lon1) * cosLat2;
            double x = cosLat1 * Math.sin(lat2) - Math.sin(lat1) * cosLat2 * Math.cos(lon2 - lon1);
            results[1] = Math.toDegrees(Math.atan2(y, x));
        }
    }
}

