/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;

public class KmlVec2 {
    public double x = 0.5;
    public Units xUnits = Units.FRACTION;
    public double y = 0.5;
    public Units yUnits = Units.FRACTION;

    public KmlVec2() {
    }

    public KmlVec2(double x, Units xUnits, double y, Units yUnits) {
        this.x = x;
        this.xUnits = xUnits;
        this.y = y;
        this.yUnits = yUnits;
    }

    public double[] getCoords(double sourceWidth, double sourceHeight) {
        return this.getCoords(sourceWidth, sourceHeight, new double[2]);
    }

    public double[] getCoords(double sourceWidth, double sourceHeight, double[] result) {
        if (result == null || result.length != 2) {
            result = new double[2];
        }
        if (this.xUnits == Units.FRACTION) {
            result[0] = sourceWidth * this.x;
        } else if (this.xUnits == Units.PIXELS) {
            result[0] = this.x;
        } else if (this.xUnits == Units.INSET_PIXELS) {
            result[0] = sourceWidth - this.x;
        }
        if (this.yUnits == Units.FRACTION) {
            result[1] = sourceHeight * (1.0 - this.y);
        } else if (this.yUnits == Units.PIXELS) {
            result[1] = sourceHeight - this.y;
        } else if (this.yUnits == Units.INSET_PIXELS) {
            result[1] = this.y;
        }
        return result;
    }

    public String getAsXmlText() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t\t<hotSpot x=\"").append(this.x).append("\" y=\"").append(this.y).append("\"");
        sb.append(" xunits=\"");
        switch (this.xUnits) {
            case FRACTION: {
                sb.append("fraction");
                break;
            }
            case PIXELS: {
                sb.append("pixels");
                break;
            }
            case INSET_PIXELS: {
                sb.append("insetPixels");
            }
        }
        sb.append("\"");
        sb.append(" yunits=\"");
        switch (this.yUnits) {
            case FRACTION: {
                sb.append("fraction");
                break;
            }
            case PIXELS: {
                sb.append("pixels");
                break;
            }
            case INSET_PIXELS: {
                sb.append("insetPixels");
            }
        }
        sb.append("\"");
        sb.append(" />");
        return sb.toString();
    }

    public KmlVec2 getCopy() {
        KmlVec2 vec = new KmlVec2();
        vec.x = this.x;
        vec.xUnits = this.xUnits;
        vec.y = this.y;
        vec.yUnits = this.yUnits;
        return vec;
    }

    public void write(DataWriterBigEndian dw) throws IOException {
        dw.writeDouble(this.x);
        dw.writeInt(this.xUnits.ordinal());
        dw.writeDouble(this.y);
        dw.writeInt(this.yUnits.ordinal());
    }

    public static KmlVec2 read(DataReaderBigEndian dr) throws IOException {
        KmlVec2 vec = new KmlVec2();
        vec.x = dr.readDouble();
        vec.xUnits = Units.values()[dr.readInt()];
        vec.y = dr.readDouble();
        vec.yUnits = Units.values()[dr.readInt()];
        return vec;
    }

    public static enum Units {
        FRACTION,
        PIXELS,
        INSET_PIXELS;

    }
}

