/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects;

import java.io.IOException;
import java.util.Hashtable;
import locus.api.objects.Storable;
import locus.api.objects.enums.PointRteAction;
import locus.api.objects.extra.GeoDataExtra;
import locus.api.objects.extra.GeoDataStyle;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;
import locus.api.utils.Utils;

public abstract class GeoData
extends Storable {
    private static final String TAG = "GeoData";
    @Deprecated
    public long id;
    protected String name;
    protected long timeCreated;
    public GeoDataExtra extraData;
    public GeoDataStyle styleNormal;
    public GeoDataStyle styleHighlight;
    private byte mState;
    private ReadWriteMode mReadWriteMode;
    public Object tag;
    private Hashtable<String, Object> mTags;
    public int dist;

    public GeoData() {
        this.setBasics();
    }

    public GeoData(DataReaderBigEndian dr) throws IOException {
        super(dr);
        this.setBasics();
    }

    public GeoData(byte[] data) throws IOException {
        super(data);
        this.setBasics();
    }

    private void setBasics() {
        this.setEnabled(true);
        this.setVisible(true);
        this.setSelected(false);
    }

    public boolean isEnabled() {
        return this.isStateValue(0);
    }

    public void setEnabled(boolean enabled) {
        this.setState(0, enabled);
    }

    public boolean isVisible() {
        return this.isStateValue(0) && this.isStateValue(1);
    }

    public void setVisible(boolean visible) {
        this.setState(1, visible);
    }

    public boolean isSelected() {
        return this.isStateValue(0) && this.isStateValue(1) && this.isStateValue(2);
    }

    public void setSelected(boolean selected) {
        this.setState(2, selected);
    }

    private boolean isStateValue(int position) {
        return (this.mState >> position & 1) == 1;
    }

    private void setState(int position, boolean value) {
        this.mState = value ? (byte)(this.mState | 1 << position) : (byte)(this.mState & ~(1 << position));
    }

    protected void readExtraData(DataReaderBigEndian dr) throws IOException {
        if (dr.readBoolean()) {
            this.extraData = new GeoDataExtra();
            this.extraData.read(dr);
        }
    }

    protected void writeExtraData(DataWriterBigEndian dw) throws IOException {
        if (this.extraData != null && this.extraData.getCount() > 0) {
            dw.writeBoolean(true);
            dw.writeStorable(this.extraData);
        } else {
            dw.writeBoolean(false);
        }
    }

    protected void readStyles(DataReaderBigEndian dr) throws IOException {
        if (dr.readBoolean()) {
            this.styleNormal = new GeoDataStyle(dr);
        }
        if (dr.readBoolean()) {
            this.styleHighlight = new GeoDataStyle(dr);
        }
    }

    protected void writeStyles(DataWriterBigEndian dw) throws IOException {
        if (this.styleNormal != null) {
            dw.writeBoolean(true);
            dw.writeStorable(this.styleNormal);
        } else {
            dw.writeBoolean(false);
        }
        if (this.styleHighlight != null) {
            dw.writeBoolean(true);
            dw.writeStorable(this.styleHighlight);
        } else {
            dw.writeBoolean(false);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public void setTimeCreated(long time) {
        this.timeCreated = time;
    }

    public Object getTag(String key) {
        if (key == null || key.length() == 0) {
            Logger.logW(TAG, "getTag(" + key + "), invalid key");
            return null;
        }
        if (this.mTags == null) {
            return null;
        }
        return this.mTags.get(key);
    }

    public void setTag(String key, Object value) {
        if (key == null || key.length() == 0) {
            Logger.logW(TAG, "setTag(" + key + "), invalid key");
            return;
        }
        if (value == null) {
            if (this.mTags != null) {
                this.mTags.remove(key);
            }
        } else {
            if (this.mTags == null) {
                this.mTags = new Hashtable();
            }
            this.mTags.put(key, value);
        }
    }

    public byte[] getExtraDataRaw() {
        try {
            DataWriterBigEndian dw = new DataWriterBigEndian();
            this.writeExtraData(dw);
            return dw.toByteArray();
        }
        catch (IOException e) {
            Logger.logE(TAG, "getExtraDataRaw()", e);
            return null;
        }
    }

    public void setExtraDataRaw(byte[] data) {
        try {
            this.readExtraData(new DataReaderBigEndian(data));
        }
        catch (Exception e) {
            Logger.logE(TAG, "setExtraDataRaw(" + data + ")", e);
            this.extraData = null;
        }
    }

    public boolean hasExtraData() {
        return this.extraData != null;
    }

    public boolean addParameter(int paramId, String param) {
        boolean created = this.createExtraData();
        return this.afterItemAdded(this.extraData.addParameter(paramId, param), created);
    }

    public boolean addParameter(int paramId, byte[] param) {
        boolean created = this.createExtraData();
        return this.afterItemAdded(this.extraData.addParameter(paramId, param), created);
    }

    public boolean addParameter(int paramId, int value) {
        boolean created = this.createExtraData();
        return this.afterItemAdded(this.extraData.addParameter(paramId, Integer.toString(value)), created);
    }

    public boolean addParameter(int paramId, byte param) {
        boolean created = this.createExtraData();
        return this.afterItemAdded(this.extraData.addParameter(paramId, param), created);
    }

    public String getParameter(int paramId) {
        if (this.extraData == null) {
            return null;
        }
        return this.extraData.getParameter(paramId);
    }

    public byte[] getParameterRaw(int paramId) {
        if (this.extraData == null) {
            return null;
        }
        return this.extraData.getParameterRaw(paramId);
    }

    public boolean hasParameter(int paramId) {
        if (this.extraData == null) {
            return false;
        }
        return this.extraData.hasParameter(paramId);
    }

    public String removeParameter(int paramId) {
        if (this.extraData == null) {
            return null;
        }
        return this.extraData.removeParameter(paramId);
    }

    public byte getParameterSource() {
        if (this.extraData == null) {
            return 48;
        }
        byte[] res = this.extraData.getParameterRaw(0);
        if (res == null || res.length != 1) {
            return 48;
        }
        return res[0];
    }

    public void setParameterSource(byte source) {
        this.addParameter(0, source);
    }

    public boolean isParameterSource(byte expectedSource) {
        return this.getParameterSource() == expectedSource;
    }

    public void removeParameterSource() {
        this.removeParameter(0);
    }

    public String getParameterStyleName() {
        if (this.extraData == null) {
            return "";
        }
        return this.extraData.getParameter(5);
    }

    public void setParameterStyleName(String style) {
        this.addParameter(5, style);
    }

    public void removeParameterStyleName() {
        if (this.extraData == null) {
            return;
        }
        this.extraData.removeParameter(5);
    }

    public boolean hasParameterDescription() {
        return this.getParameterDescription().length() > 0;
    }

    public String getParameterDescription() {
        if (this.extraData == null) {
            return "";
        }
        return this.extraData.getParameterNotNull(30);
    }

    public void setParameterDescription(String desc) {
        this.addParameter(30, desc);
    }

    public PointRteAction getParameterRteAction() {
        String param = this.getParameter(110);
        if (param != null && param.length() > 0) {
            return PointRteAction.getActionById(Utils.parseInt(param));
        }
        return PointRteAction.UNDEFINED;
    }

    public void setParameterRteAction(PointRteAction action) {
        if (action == null) {
            Logger.logW(TAG, "setParameterRteAction(), attempt to set invalid parameter");
            return;
        }
        this.addParameter(110, action.getId());
    }

    public void addEmail(String email) {
        this.addEmail(null, email);
    }

    public void addEmail(String label, String email) {
        boolean created = this.createExtraData();
        this.afterItemAdded(this.extraData.addEmail(label, email), created);
    }

    public void addPhone(String phone) {
        this.addPhone(null, phone);
    }

    public void addPhone(String label, String phone) {
        boolean created = this.createExtraData();
        this.afterItemAdded(this.extraData.addPhone(label, phone), created);
    }

    public void addUrl(String url) {
        this.addUrl(null, url);
    }

    public void addUrl(String label, String url) {
        boolean created = this.createExtraData();
        this.afterItemAdded(this.extraData.addUrl(label, url), created);
    }

    public boolean addAttachmentAudio(String uri) {
        boolean created = this.createExtraData();
        return this.afterItemAdded(this.extraData.addAudio(uri), created);
    }

    public boolean addAttachmentPhoto(String uri) {
        boolean created = this.createExtraData();
        return this.afterItemAdded(this.extraData.addPhoto(uri), created);
    }

    public boolean addAttachmentVideo(String uri) {
        boolean created = this.createExtraData();
        return this.afterItemAdded(this.extraData.addVideo(uri), created);
    }

    public boolean addAttachmentOther(String uri) {
        boolean created = this.createExtraData();
        return this.afterItemAdded(this.extraData.addOtherFile(uri), created);
    }

    public int getParamRteIndex() {
        String parIndex = this.getParameter(100);
        if (parIndex != null) {
            return Utils.parseInt(parIndex);
        }
        return -1;
    }

    public byte[] getStyles() {
        try {
            DataWriterBigEndian dw = new DataWriterBigEndian();
            this.writeStyles(dw);
            return dw.toByteArray();
        }
        catch (IOException e) {
            Logger.logE(TAG, "getStylesRaw()", e);
            return null;
        }
    }

    public void setStyles(byte[] data) {
        try {
            this.readStyles(new DataReaderBigEndian(data));
        }
        catch (Exception e) {
            Logger.logE(TAG, "setExtraStyle(" + data + ")", e);
            this.extraData = null;
        }
    }

    public ReadWriteMode getReadWriteMode() {
        if (this.mReadWriteMode == null) {
            return ReadWriteMode.READ_WRITE;
        }
        return this.mReadWriteMode;
    }

    public void setReadWriteMode(ReadWriteMode mode) {
        this.mReadWriteMode = mode;
    }

    private boolean createExtraData() {
        if (this.extraData == null) {
            this.extraData = new GeoDataExtra();
            return true;
        }
        return false;
    }

    private boolean afterItemAdded(boolean added, boolean created) {
        if (added) {
            return true;
        }
        if (created) {
            this.extraData = null;
        }
        return false;
    }

    public static enum ReadWriteMode {
        READ_ONLY,
        READ_WRITE;

    }
}

