/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import java.util.ArrayList;
import locus.api.objects.Storable;
import locus.api.objects.extra.KmlVec2;
import locus.api.objects.extra.LineStyle;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;

public class GeoDataStyle
extends Storable {
    private static final String TAG = "GeoDataStyle";
    private String mId;
    private String mName;
    BalloonStyle balloonStyle;
    IconStyle iconStyle;
    LabelStyle labelStyle;
    ListStyle listStyle;
    private LineStyle mLineStyle;
    public static final int HOTSPOT_BOTTOM_CENTER = 0;
    public static final int HOTSPOT_TOP_LEFT = 1;
    public static final int HOTSPOT_CENTER_CENTER = 2;
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final int COLOR_DEFAULT = -1;

    public GeoDataStyle() {
        this("");
    }

    public GeoDataStyle(String name) {
        if (name != null) {
            this.mName = name;
        }
    }

    public GeoDataStyle(DataReaderBigEndian dr) throws IOException {
        super(dr);
    }

    public GeoDataStyle(byte[] data) throws IOException {
        super(data);
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id) {
        if (id == null) {
            id = "";
        }
        this.mId = id;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.mName = name;
    }

    public IconStyle getIconStyle() {
        return this.iconStyle;
    }

    public String getIconStyleIconUrl() {
        if (this.iconStyle == null) {
            return null;
        }
        return this.iconStyle.getIconHref();
    }

    public void setIconStyle(String iconUrl, float scale) {
        this.setIconStyle(iconUrl, -1, 0.0f, scale);
    }

    public void setIconStyle(String iconUrl, int color, float heading, float scale) {
        this.iconStyle = new IconStyle();
        this.iconStyle.setIconHref(iconUrl);
        this.iconStyle.color = color;
        this.iconStyle.heading = heading;
        this.iconStyle.setScale(scale);
        this.setIconStyleHotSpot(0);
    }

    public void setIconStyleHotSpot(int hotspot) {
        if (this.iconStyle == null) {
            Logger.logW(TAG, "setIconStyleHotSpot(" + hotspot + "), initialize IconStyle before settings hotSpot!");
            return;
        }
        this.iconStyle.hotSpot = hotspot == 1 ? new KmlVec2(0.0, KmlVec2.Units.FRACTION, 1.0, KmlVec2.Units.FRACTION) : (hotspot == 2 ? new KmlVec2(0.5, KmlVec2.Units.FRACTION, 0.5, KmlVec2.Units.FRACTION) : GeoDataStyle.generateDefaultHotSpot());
    }

    private static KmlVec2 generateDefaultHotSpot() {
        return new KmlVec2(0.5, KmlVec2.Units.FRACTION, 0.0, KmlVec2.Units.FRACTION);
    }

    public void setIconStyleHotSpot(KmlVec2 vec2) {
        if (this.iconStyle == null || vec2 == null) {
            Logger.logW(TAG, "setIconStyleHotSpot(" + vec2 + "), initialize IconStyle before settings hotSpot or hotSpot is null!");
            return;
        }
        this.iconStyle.hotSpot = vec2;
    }

    public LabelStyle getLabelStyle() {
        return this.labelStyle;
    }

    public LineStyle getLineStyle() {
        return this.mLineStyle;
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.mLineStyle = lineStyle;
    }

    public void setLineStyle(int color, float width) {
        if (this.mLineStyle == null) {
            this.mLineStyle = new LineStyle();
        }
        this.mLineStyle.setColorBase(color);
        this.mLineStyle.setWidth(width);
    }

    public void setPolyStyle(int color) {
        if (this.mLineStyle == null) {
            this.mLineStyle = new LineStyle();
            this.mLineStyle.setDrawBase(false);
        }
        this.mLineStyle.setDrawFill(true);
        this.mLineStyle.setColorFill(color);
    }

    @Override
    protected int getVersion() {
        return 2;
    }

    @Override
    public void reset() {
        this.mId = "";
        this.mName = "";
        this.balloonStyle = null;
        this.iconStyle = null;
        this.labelStyle = null;
        this.listStyle = null;
        this.mLineStyle = null;
    }

    @Override
    protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
        this.mId = dr.readString();
        this.mName = dr.readString();
        if (version == 0) {
            return;
        }
        LineStyleOld lineStyleOld = null;
        PolyStyleOld polyStyleOld = null;
        try {
            if (dr.readBoolean()) {
                this.balloonStyle = Storable.read(BalloonStyle.class, dr);
            }
            if (dr.readBoolean()) {
                this.iconStyle = Storable.read(IconStyle.class, dr);
            }
            if (dr.readBoolean()) {
                this.labelStyle = Storable.read(LabelStyle.class, dr);
            }
            if (dr.readBoolean()) {
                lineStyleOld = Storable.read(LineStyleOld.class, dr);
            }
            if (dr.readBoolean()) {
                this.listStyle = Storable.read(ListStyle.class, dr);
            }
            if (dr.readBoolean()) {
                polyStyleOld = Storable.read(PolyStyleOld.class, dr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mLineStyle = this.convertToNewLineStyle(lineStyleOld, polyStyleOld);
        if (version >= 2 && dr.readBoolean()) {
            this.mLineStyle = new LineStyle();
            this.mLineStyle.read(dr);
        }
    }

    @Override
    protected void writeObject(DataWriterBigEndian dw) throws IOException {
        dw.writeString(this.mId);
        dw.writeString(this.mName);
        if (this.balloonStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            this.balloonStyle.write(dw);
        }
        if (this.iconStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            this.iconStyle.write(dw);
        }
        if (this.labelStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            this.labelStyle.write(dw);
        }
        dw.writeBoolean(false);
        if (this.listStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            this.listStyle.write(dw);
        }
        dw.writeBoolean(false);
        if (this.mLineStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            this.mLineStyle.write(dw);
        }
    }

    private LineStyle convertToNewLineStyle(LineStyleOld ls, PolyStyleOld ps) {
        if (ls == null && ps == null) {
            return null;
        }
        LineStyle lsNew = new LineStyle();
        if (ls != null) {
            lsNew.setDrawBase(true);
            lsNew.setColorBase(ls.color);
            if (ls.lineType == LineStyleOld.LineType.NORMAL) {
                lsNew.setDrawSymbol(false);
            } else {
                lsNew.setDrawSymbol(true);
                lsNew.setSymbol(LineStyle.Symbol.valueOf(ls.lineType.name()));
            }
            lsNew.setColoring(LineStyle.Coloring.valueOf(ls.colorStyle.name()));
            lsNew.setWidth(ls.getWidth());
            lsNew.setUnits(LineStyle.Units.valueOf(ls.units.name()));
            lsNew.setDrawOutline(ls.drawOutline);
            lsNew.setColorOutline(ls.colorOutline);
        } else {
            lsNew.setDrawBase(false);
        }
        if (ps != null) {
            lsNew.setDrawFill(ps.fill);
            lsNew.setColorFill(ps.color);
        } else {
            lsNew.setDrawFill(false);
        }
        return lsNew;
    }

    @Deprecated
    public static class PolyStyleOld
    extends Storable {
        public int color = -1;
        public boolean fill = true;
        public boolean outline = true;

        @Override
        protected int getVersion() {
            return 0;
        }

        @Override
        public void reset() {
            this.color = -1;
            this.fill = true;
            this.outline = true;
        }

        @Override
        protected void readObject(int version, DataReaderBigEndian dis) throws IOException {
            this.color = dis.readInt();
            this.fill = dis.readBoolean();
            this.outline = dis.readBoolean();
        }

        @Override
        protected void writeObject(DataWriterBigEndian dw) throws IOException {
        }
    }

    @Deprecated
    public static class LineStyleOld
    extends Storable {
        public int color;
        private float mWidth;
        int gxOuterColor;
        float gxOuterWidth;
        @Deprecated
        float gxPhysicalWidth;
        boolean gxLabelVisibility;
        ColorStyle colorStyle;
        public Units units;
        LineType lineType;
        boolean drawOutline;
        int colorOutline;
        private int mObjectVersion;

        public float getWidth() {
            return this.mWidth;
        }

        public void setWidth(float width) {
            this.mWidth = width;
        }

        public Units getUnits() {
            return this.units;
        }

        public void setUnits(Units units) {
            this.units = units;
        }

        @Override
        protected int getVersion() {
            return 2;
        }

        @Override
        public void reset() {
            this.mObjectVersion = this.getVersion();
            this.color = -1;
            this.mWidth = 1.0f;
            this.gxOuterColor = -1;
            this.gxOuterWidth = 0.0f;
            this.gxPhysicalWidth = 0.0f;
            this.gxLabelVisibility = false;
            this.colorStyle = ColorStyle.SIMPLE;
            this.units = Units.PIXELS;
            this.lineType = LineType.NORMAL;
            this.drawOutline = false;
            this.colorOutline = -1;
        }

        @Override
        protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
            int lt;
            int un;
            this.mObjectVersion = version;
            this.color = dr.readInt();
            this.mWidth = dr.readFloat();
            this.gxOuterColor = dr.readInt();
            this.gxOuterWidth = dr.readFloat();
            this.gxPhysicalWidth = dr.readFloat();
            this.gxLabelVisibility = dr.readBoolean();
            int cs = dr.readInt();
            if (cs < ColorStyle.values().length) {
                this.colorStyle = ColorStyle.values()[cs];
            }
            if ((un = dr.readInt()) < Units.values().length) {
                this.units = Units.values()[un];
            }
            if ((lt = dr.readInt()) < LineType.values().length) {
                this.lineType = LineType.values()[lt];
            }
            if (version >= 1) {
                this.drawOutline = dr.readBoolean();
                this.colorOutline = dr.readInt();
            }
        }

        @Override
        protected void writeObject(DataWriterBigEndian dw) throws IOException {
        }

        private static enum LineType {
            NORMAL,
            DOTTED,
            DASHED_1,
            DASHED_2,
            DASHED_3,
            SPECIAL_1,
            SPECIAL_2,
            SPECIAL_3,
            ARROW_1,
            ARROW_2,
            ARROW_3,
            CROSS_1,
            CROSS_2;

        }

        private static enum Units {
            PIXELS,
            METRES;

        }

        private static enum ColorStyle {
            SIMPLE,
            BY_SPEED,
            BY_ALTITUDE,
            BY_ACCURACY,
            BY_SPEED_CHANGE,
            BY_SLOPE_REL,
            BY_HRM,
            BY_CADENCE,
            BY_SLOPE_ABS;

        }
    }

    public static class ListStyle
    extends Storable {
        public ListItemType listItemType = ListItemType.CHECK;
        public int bgColor = -1;
        public ArrayList<ItemIcon> itemIcons = new ArrayList();

        @Override
        protected int getVersion() {
            return 0;
        }

        @Override
        public void reset() {
            this.listItemType = ListItemType.CHECK;
            this.bgColor = -1;
            this.itemIcons = new ArrayList();
        }

        @Override
        protected void readObject(int version, DataReaderBigEndian dis) throws IOException {
            int style = dis.readInt();
            if (style < ListItemType.values().length) {
                this.listItemType = ListItemType.values()[style];
            }
            this.bgColor = dis.readInt();
            int itemsCount = dis.readInt();
            for (int i = 0; i < itemsCount; ++i) {
                ItemIcon itemIcon = new ItemIcon();
                int iconStyle = dis.readInt();
                if (iconStyle < ItemIcon.State.values().length) {
                    itemIcon.state = ItemIcon.State.values()[iconStyle];
                }
                itemIcon.href = dis.readString();
                this.itemIcons.add(itemIcon);
            }
        }

        @Override
        protected void writeObject(DataWriterBigEndian dw) throws IOException {
            dw.writeBoolean(true);
            dw.writeInt(this.listItemType.ordinal());
            dw.writeInt(this.bgColor);
            dw.writeInt(this.itemIcons.size());
            for (ItemIcon itemIcon : this.itemIcons) {
                dw.writeInt(itemIcon.state.ordinal());
                dw.writeString(itemIcon.href);
            }
        }

        public static class ItemIcon {
            public State state = State.OPEN;
            public String href = "";

            public static enum State {
                OPEN,
                CLOSED,
                ERROR,
                FETCHING0,
                FETCHING1,
                FETCHING2;

            }
        }

        public static enum ListItemType {
            CHECK,
            CHECK_OFF_ONLY,
            CHECK_HIDE_CHILDREN,
            RADIO_FOLDER;

        }
    }

    public static class LabelStyle
    extends Storable {
        private int mColor = -1;
        private float mScale = 1.0f;

        public int getColor() {
            return this.mColor;
        }

        public void setColor(int color) {
            this.mColor = color;
        }

        public float getScale() {
            return this.mScale;
        }

        public void setScale(float scale) {
            if (scale < 0.0f) {
                scale = 0.0f;
            }
            this.mScale = scale;
        }

        @Override
        protected int getVersion() {
            return 0;
        }

        @Override
        public void reset() {
            this.mColor = -1;
            this.mScale = 1.0f;
        }

        @Override
        protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
            this.mColor = dr.readInt();
            this.mScale = dr.readFloat();
        }

        @Override
        protected void writeObject(DataWriterBigEndian dw) throws IOException {
            dw.writeInt(this.mColor);
            dw.writeFloat(this.mScale);
        }
    }

    public static class IconStyle
    extends Storable {
        public int color;
        private float mScale;
        public float heading;
        @Deprecated
        public String iconHref;
        public KmlVec2 hotSpot;
        public Object icon;
        public int iconW;
        public int iconH;
        public float scaleCurrent;

        public float getScale() {
            return this.mScale;
        }

        public void setScale(float scale) {
            if (scale != 0.0f) {
                this.mScale = scale;
                this.scaleCurrent = scale;
            }
        }

        private String getIconHref() {
            return this.iconHref;
        }

        public void setIconHref(String iconHref) {
            if (iconHref == null) {
                iconHref = "";
            }
            this.iconHref = iconHref;
        }

        @Override
        protected int getVersion() {
            return 0;
        }

        @Override
        public void reset() {
            this.color = -1;
            this.mScale = 1.0f;
            this.heading = 0.0f;
            this.iconHref = null;
            this.hotSpot = GeoDataStyle.generateDefaultHotSpot();
            this.icon = null;
            this.iconW = -1;
            this.iconH = -1;
            this.scaleCurrent = 1.0f;
        }

        @Override
        protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
            this.color = dr.readInt();
            this.mScale = dr.readFloat();
            this.heading = dr.readFloat();
            this.iconHref = dr.readString();
            this.hotSpot = KmlVec2.read(dr);
        }

        @Override
        protected void writeObject(DataWriterBigEndian dw) throws IOException {
            dw.writeInt(this.color);
            dw.writeFloat(this.mScale);
            dw.writeFloat(this.heading);
            dw.writeString(this.iconHref);
            this.hotSpot.write(dw);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("IconStyle [");
            sb.append("color:").append(this.color);
            sb.append(", scale:").append(this.mScale);
            sb.append(", heading:").append(this.heading);
            sb.append(", iconHref:").append(this.iconHref);
            sb.append(", hotSpot:").append(this.hotSpot);
            sb.append(", icon:").append(this.icon);
            sb.append(", iconW:").append(this.iconW);
            sb.append(", iconH:").append(this.iconH);
            sb.append(", scaleCurrent:").append(this.scaleCurrent);
            sb.append("]");
            return sb.toString();
        }
    }

    public static class BalloonStyle
    extends Storable {
        public int bgColor;
        public int textColor;
        public String text;
        public DisplayMode displayMode;

        @Override
        protected int getVersion() {
            return 0;
        }

        @Override
        public void reset() {
            this.bgColor = -1;
            this.textColor = -16777216;
            this.text = "";
            this.displayMode = DisplayMode.DEFAULT;
        }

        @Override
        protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
            this.bgColor = dr.readInt();
            this.textColor = dr.readInt();
            this.text = dr.readString();
            int mode = dr.readInt();
            if (mode < DisplayMode.values().length) {
                this.displayMode = DisplayMode.values()[mode];
            }
        }

        @Override
        protected void writeObject(DataWriterBigEndian dw) throws IOException {
            dw.writeInt(this.bgColor);
            dw.writeInt(this.textColor);
            dw.writeString(this.text);
            dw.writeInt(this.displayMode.ordinal());
        }

        public static enum DisplayMode {
            DEFAULT,
            HIDE;

        }
    }
}

