/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;

public abstract class Storable {
    private static final String TAG = "Storable";

    protected abstract int getVersion();

    public void read(byte[] data) throws IOException {
        DataReaderBigEndian dr = new DataReaderBigEndian(data);
        this.read(dr);
    }

    public void read(DataReaderBigEndian dr) throws IOException {
        BodyContainer bc = Storable.readHeader(dr);
        this.readObject(bc.version, new DataReaderBigEndian(bc.data));
    }

    private static BodyContainer readHeader(DataReaderBigEndian dr) throws IOException {
        BodyContainer bc = new BodyContainer();
        bc.version = dr.readInt();
        int size = dr.readInt();
        if (size < 0 || size > 0x1400000) {
            throw new IOException("item size too big, size:" + size + ", max: 20MB");
        }
        bc.data = dr.readBytes(size);
        return bc;
    }

    public void read(DataInputStream input) throws IOException {
        BodyContainer bc = Storable.readHeader(input);
        this.readObject(bc.version, new DataReaderBigEndian(bc.data));
    }

    private static BodyContainer readHeader(DataInputStream dis) throws IOException {
        BodyContainer bc = new BodyContainer();
        bc.version = dis.readInt();
        int size = dis.readInt();
        if (size < 0 || size > 0xA00000) {
            throw new IOException("item size too big, size:" + size + ", max: 10MB");
        }
        bc.data = new byte[size];
        dis.read(bc.data);
        return bc;
    }

    protected abstract void readObject(int var1, DataReaderBigEndian var2) throws IOException;

    public void write(DataWriterBigEndian dw) throws IOException {
        dw.writeInt(this.getVersion());
        dw.writeInt(0);
        int startSize = dw.size();
        this.writeObject(dw);
        int totalSize = dw.size() - startSize;
        if (totalSize > 0) {
            dw.storePosition();
            dw.moveTo(startSize - 4);
            dw.writeInt(totalSize);
            dw.restorePosition();
        }
    }

    protected abstract void writeObject(DataWriterBigEndian var1) throws IOException;

    public Storable getCopy() throws IOException, InstantiationException, IllegalAccessException {
        byte[] data = this.getAsBytes();
        return Storable.read(this.getClass(), new DataReaderBigEndian(data));
    }

    public byte[] getAsBytes() {
        try {
            DataWriterBigEndian dw = new DataWriterBigEndian();
            this.write(dw);
            return dw.toByteArray();
        }
        catch (IOException e) {
            Logger.logE(TAG, "getAsBytes()", e);
            return null;
        }
    }

    public static <E extends Storable> E read(Class<E> claz, DataReaderBigEndian dr) throws IOException, InstantiationException, IllegalAccessException {
        BodyContainer bc = Storable.readHeader(dr);
        Storable storable = (Storable)claz.newInstance();
        storable.readObject(bc.version, new DataReaderBigEndian(bc.data));
        return (E)storable;
    }

    public static void readUnknownObject(DataReaderBigEndian dr) throws IOException {
        Storable.readHeader(dr);
    }

    public static <E extends Storable> List<E> readList(Class<E> claz, byte[] data) throws IOException {
        return new DataReaderBigEndian(data).readListStorable(claz);
    }

    public static <E extends Storable> List<E> readList(Class<E> claz, DataInputStream dis) throws IOException {
        ArrayList<Storable> objs = new ArrayList<Storable>();
        int count = dis.readInt();
        if (count == 0) {
            return objs;
        }
        for (int i = 0; i < count; ++i) {
            try {
                Storable item = (Storable)claz.newInstance();
                item.read(dis);
                objs.add(item);
                continue;
            }
            catch (InstantiationException e) {
                Logger.logE(TAG, "readList(" + claz + ", " + dis + ")", e);
                continue;
            }
            catch (IllegalAccessException e) {
                Logger.logE(TAG, "readList(" + claz + ", " + dis + ")", e);
            }
        }
        return objs;
    }

    public static byte[] getAsBytes(List<? extends Storable> data) {
        try {
            DataWriterBigEndian dw = new DataWriterBigEndian();
            dw.writeListStorable(data);
            return dw.toByteArray();
        }
        catch (Exception e) {
            Logger.logE(TAG, "getAsBytes(" + data + ")", e);
            return null;
        }
    }

    public static void writeList(List<? extends Storable> objs, DataOutputStream dos) throws IOException {
        int size = objs == null ? 0 : objs.size();
        dos.writeInt(size);
        if (size == 0) {
            return;
        }
        int n = objs.size();
        for (int i = 0; i < n; ++i) {
            dos.write(objs.get(i).getAsBytes());
        }
    }

    private static class BodyContainer {
        int version;
        byte[] data;

        private BodyContainer() {
        }
    }
}

