/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;
import locus.api.utils.SparseArrayCompat;
import locus.api.utils.Utils;

public class GeoDataExtra
extends Storable {
    private static final String TAG = "GeoDataExtra";
    public static final byte SOURCE_UNKNOWN = 48;
    public static final byte SOURCE_PARKING_SERVICE = 49;
    public static final byte SOURCE_GEOCACHING_WAYPOINT = 50;
    public static final byte SOURCE_MAP_TEMP = 51;
    public static final byte SOURCE_ROUTE_WAYPOINT = 52;
    public static final byte SOURCE_ROUTE_LOCATION = 53;
    public static final byte SOURCE_OPENSTREETBUGS = 55;
    public static final byte SOURCE_INVISIBLE = 56;
    public static final byte SOURCE_POI_OSM_DB = 57;
    public static final byte SOURCE_MUNZEE = 58;
    public static final byte SOURCE_LIVE_TRACKING = 59;
    public static final byte SOURCE_NAVI_BLOCKED_AREA = 60;
    public static final byte SOURCE_MAP_SELECTION = 61;
    public static final int VALUE_RTE_TYPE_GENERATED = -1;
    public static final int VALUE_RTE_TYPE_NO_TYPE = 100;
    public static final int VALUE_RTE_TYPE_CAR = 6;
    public static final int VALUE_RTE_TYPE_CAR_FAST = 0;
    public static final int VALUE_RTE_TYPE_CAR_SHORT = 1;
    public static final int VALUE_RTE_TYPE_MOTORCYCLE = 7;
    public static final int VALUE_RTE_TYPE_CYCLE = 2;
    public static final int VALUE_RTE_TYPE_CYCLE_FAST = 4;
    public static final int VALUE_RTE_TYPE_CYCLE_SHORT = 5;
    public static final int VALUE_RTE_TYPE_CYCLE_MTB = 8;
    public static final int VALUE_RTE_TYPE_CYCLE_RACING = 9;
    public static final int VALUE_RTE_TYPE_FOOT_01 = 3;
    public static final int VALUE_RTE_TYPE_FOOT_02 = 10;
    public static final int VALUE_RTE_TYPE_FOOT_03 = 11;
    public static final int[] RTE_TYPES_SORTED = new int[]{100, 6, 0, 1, 7, 2, 4, 5, 8, 9, 3, 10, 11};
    public static final int PAR_SOURCE = 0;
    public static final int PAR_STYLE_NAME = 5;
    public static final int PAR_AREA_SIZE = 12;
    public static final int PAR_DB_POI_EXTRA_DATA = 13;
    public static final int PAR_KML_TRIP_ID = 14;
    public static final int PAR_GOOGLE_PLACES_REFERENCE = 15;
    public static final int PAR_GOOGLE_PLACES_RATING = 16;
    public static final int PAR_GOOGLE_PLACES_DETAILS = 17;
    public static final int PAR_INTENT_EXTRA_CALLBACK = 20;
    public static final int PAR_INTENT_EXTRA_ON_DISPLAY = 21;
    public static final int PAR_DESCRIPTION = 30;
    public static final int PAR_COMMENT = 31;
    public static final int PAR_RELATIVE_WORKING_DIR = 32;
    public static final int PAR_TYPE = 33;
    public static final int PAR_GEOCACHE_CODE = 34;
    public static final int PAR_POI_ALERT_INCLUDE = 35;
    public static final int PAR_ADDRESS_STREET = 50;
    public static final int PAR_ADDRESS_CITY = 51;
    public static final int PAR_ADDRESS_REGION = 52;
    public static final int PAR_ADDRESS_POST_CODE = 53;
    public static final int PAR_ADDRESS_COUNTRY = 54;
    public static final int PAR_RTE_INDEX = 100;
    public static final int PAR_RTE_DISTANCE_F = 101;
    public static final int PAR_RTE_TIME_I = 102;
    public static final int PAR_RTE_SPEED_F = 103;
    public static final int PAR_RTE_TURN_COST = 104;
    public static final int PAR_RTE_STREET = 109;
    public static final int PAR_RTE_POINT_ACTION = 110;
    public static final int PAR_RTE_COMPUTE_TYPE = 120;
    public static final int PAR_RTE_SIMPLE_ROUNDABOUTS = 121;
    public static final int PAR_RTE_PLAN_DEFINITION = 122;
    public static final int PAR_OSM_NOTES_ID = 301;
    public static final int PAR_OSM_NOTES_CLOSED = 302;
    private static final int PAR_PHONE_MIN = 1000;
    private static final int PAR_PHONE_MAX = 1099;
    private static final int PAR_EMAIL_MIN = 1100;
    private static final int PAR_EMAIL_MAX = 1199;
    private static final int PAR_URL_MIN = 1200;
    private static final int PAR_URL_MAX = 1299;
    private static final int PAR_PHOTO_MIN = 1300;
    private static final int PAR_PHOTO_MAX = 1399;
    private static final int PAR_VIDEO_MIN = 1400;
    private static final int PAR_VIDEO_MAX = 1499;
    private static final int PAR_AUDIO_MIN = 1500;
    private static final int PAR_AUDIO_MAX = 1599;
    private static final int PAR_OTHER_FILES_MIN = 1800;
    private static final int PAR_OTHER_FILES_MAX = 1999;
    SparseArrayCompat<byte[]> parameters = new SparseArrayCompat();

    @Override
    protected int getVersion() {
        return 0;
    }

    @Override
    protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
        int size = dr.readInt();
        this.parameters.clear();
        for (int i = 0; i < size; ++i) {
            int key = dr.readInt();
            this.parameters.put(key, dr.readBytes(dr.readInt()));
        }
    }

    @Override
    protected void writeObject(DataWriterBigEndian dw) throws IOException {
        dw.writeInt(this.parameters.size());
        int m = this.parameters.size();
        for (int i = 0; i < m; ++i) {
            int key = this.parameters.keyAt(i);
            dw.writeInt(key);
            byte[] data = this.parameters.valueAt(i);
            dw.writeInt(data.length);
            if (data.length <= 0) continue;
            dw.write(data);
        }
    }

    public boolean addParameter(int key, String value) {
        if (value == null) {
            return false;
        }
        this.removeParameter(key);
        value = value.trim();
        if (value.length() == 0) {
            return false;
        }
        if (key > 1000 && key < 2000) {
            Logger.logW(TAG, "addParam(" + key + ", " + value + "), values 1000 - 1999 reserved!");
            return false;
        }
        this.parameters.put(key, Utils.doStringToBytes(value));
        return true;
    }

    public boolean addParameter(int key, byte value) {
        return this.addParameter(key, new byte[]{value});
    }

    public boolean addParameter(int key, byte[] value) {
        this.removeParameter(key);
        if (value == null || value.length == 0) {
            return false;
        }
        if (key > 1000 && key < 2000) {
            Logger.logW(TAG, "addParam(" + key + ", " + Arrays.toString(value) + "), values 1000 - 1999 reserved!");
            return false;
        }
        this.parameters.put(key, value);
        return true;
    }

    public String getParameter(int key) {
        byte[] data = this.parameters.get(key);
        if (data != null) {
            return Utils.doBytesToString(data);
        }
        return null;
    }

    public byte[] getParameterRaw(int key) {
        return this.parameters.get(key);
    }

    public String getParameterNotNull(int key) {
        String par = this.getParameter(key);
        if (par == null) {
            return "";
        }
        return par;
    }

    public boolean hasParameter(int key) {
        return this.parameters.get(key) != null;
    }

    public String removeParameter(int key) {
        String value = this.getParameter(key);
        this.parameters.remove(key);
        return value;
    }

    public int getCount() {
        return this.parameters.size();
    }

    public boolean addPhone(String phone) {
        return this.addToStorage("", phone, 1000, 1099);
    }

    public boolean addPhone(String label, String phone) {
        return this.addToStorage(label, phone, 1000, 1099);
    }

    public List<LabelTextContainer> getPhones() {
        return this.getFromStorage(1000, 1099);
    }

    public boolean removePhone(String phone) {
        return this.removeFromStorage(phone, 1000, 1099);
    }

    public void removeAllPhones() {
        this.removeAllFromStorage(1000, 1099);
    }

    public boolean addEmail(String email) {
        return this.addToStorage("", email, 1100, 1199);
    }

    public boolean addEmail(String label, String email) {
        return this.addToStorage(label, email, 1100, 1199);
    }

    public List<LabelTextContainer> getEmails() {
        return this.getFromStorage(1100, 1199);
    }

    public boolean removeEmail(String email) {
        return this.removeFromStorage(email, 1100, 1199);
    }

    public void removeAllEmails() {
        this.removeAllFromStorage(1100, 1199);
    }

    public boolean addUrl(String url) {
        return this.addToStorage("", url, 1200, 1299);
    }

    public boolean addUrl(String label, String url) {
        return this.addToStorage(label, url, 1200, 1299);
    }

    public List<LabelTextContainer> getUrls() {
        return this.getFromStorage(1200, 1299);
    }

    public boolean removeUrl(String url) {
        return this.removeFromStorage(url, 1200, 1299);
    }

    public void removeAllUrls() {
        this.removeAllFromStorage(1200, 1299);
    }

    public boolean addPhoto(String photo) {
        return this.addToStorage("", photo, 1300, 1399);
    }

    public List<String> getPhotos() {
        return this.convertToTexts(this.getFromStorage(1300, 1399));
    }

    public boolean removePhoto(String photo) {
        return this.removeFromStorage(photo, 1300, 1399);
    }

    public boolean addVideo(String video) {
        return this.addToStorage("", video, 1400, 1499);
    }

    public List<String> getVideos() {
        return this.convertToTexts(this.getFromStorage(1400, 1499));
    }

    public boolean removeVideo(String video) {
        return this.removeFromStorage(video, 1400, 1499);
    }

    public boolean addAudio(String audio) {
        return this.addToStorage("", audio, 1500, 1599);
    }

    public List<String> getAudios() {
        return this.convertToTexts(this.getFromStorage(1500, 1599));
    }

    public boolean removeAudio(String audio) {
        return this.removeFromStorage(audio, 1500, 1599);
    }

    public boolean addOtherFile(String filpath) {
        return this.addToStorage("", filpath, 1800, 1999);
    }

    public List<String> getOtherFiles() {
        return this.convertToTexts(this.getFromStorage(1800, 1999));
    }

    public boolean removeOtherFile(String filpath) {
        return this.removeFromStorage(filpath, 1800, 1999);
    }

    public List<String> getAllAttachments() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getPhotos());
        result.addAll(this.getAudios());
        result.addAll(this.getVideos());
        result.addAll(this.getOtherFiles());
        return result;
    }

    public int getAllAttachmentsCount() {
        return this.getAllAttachments().size();
    }

    private boolean addToStorage(String label, String text, int rangeFrom, int rangeTo) {
        if (text == null || text.length() == 0) {
            return false;
        }
        String item = label != null && label.length() > 0 ? label + "|" + text : text;
        for (int key = rangeFrom; key <= rangeTo; ++key) {
            String value = this.getParameter(key);
            if (value == null) {
                this.parameters.put(key, Utils.doStringToBytes(item));
                return true;
            }
            if (!value.equalsIgnoreCase(item)) continue;
            return false;
        }
        return false;
    }

    private List<LabelTextContainer> getFromStorage(int rangeFrom, int rangeTo) {
        ArrayList<LabelTextContainer> data = new ArrayList<LabelTextContainer>();
        for (int key = rangeFrom; key <= rangeTo; ++key) {
            String value = this.getParameter(key);
            if (value == null || value.length() == 0) continue;
            data.add(new LabelTextContainer(value));
        }
        return data;
    }

    private List<String> convertToTexts(List<LabelTextContainer> data) {
        ArrayList<String> result = new ArrayList<String>();
        int m = data.size();
        for (int i = 0; i < m; ++i) {
            result.add(data.get((int)i).text);
        }
        return result;
    }

    private boolean removeFromStorage(String item, int rangeFrom, int rangeTo) {
        if (item == null || item.length() == 0) {
            return false;
        }
        for (int key = rangeFrom; key <= rangeTo; ++key) {
            String value = this.getParameter(key);
            if (value == null || !value.endsWith(item)) continue;
            this.parameters.remove(key);
            return true;
        }
        return false;
    }

    private void removeAllFromStorage(int rangeFrom, int rangeTo) {
        for (int i = rangeFrom; i <= rangeTo; ++i) {
            this.parameters.remove(i);
        }
    }

    public static String generateCallbackString(String name, String packageName, String className, String returnDataName, String returnDataValue) {
        if (packageName == null || packageName.length() == 0 || className == null || className.length() == 0) {
            Logger.logD(TAG, "generateCallbackString(" + name + ", " + packageName + ", " + className + ", " + returnDataName + ", " + returnDataValue + "), invalid packageName or className parameter");
            return "";
        }
        if (name == null) {
            name = "";
        }
        if (returnDataName == null) {
            returnDataName = "";
        }
        if (returnDataValue == null) {
            returnDataValue = "";
        }
        return name + ";" + packageName + ";" + className + ";" + returnDataName + ";" + returnDataValue + ";";
    }

    public static class LabelTextContainer {
        public final String label;
        public final String text;

        public LabelTextContainer(String value) {
            if (value.contains("|")) {
                int index = value.indexOf("|");
                this.label = value.substring(0, index);
                this.text = value.substring(index + 1);
            } else {
                this.label = "";
                this.text = value;
            }
        }

        public LabelTextContainer(String label, String text) {
            this.label = label == null ? "" : label;
            this.text = text;
        }

        public String getAsText() {
            if (this.label.length() > 0) {
                return this.label + "|" + this.text;
            }
            return this.text;
        }

        public String getFormattedAsEmail() {
            String lab = this.label.length() == 0 ? this.text : this.label;
            return "<a href=\"mailto:" + this.text + "\">" + lab + "</a>";
        }

        public String getFormattedAsPhone() {
            String lab = this.label.length() == 0 ? this.text : this.label;
            return "<a href=\"tel:" + this.text + "\">" + lab + "</a>";
        }

        public String getFormattedAsUrl(boolean checkProtocol) {
            String lab = this.label.length() == 0 ? this.text : this.label;
            String url = this.text;
            if (checkProtocol && !url.contains("://")) {
                url = "http://" + url;
            }
            return "<a href=\"" + url + "\" target=\"_blank\">" + lab + "</a>";
        }
    }
}

