/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import java.util.Hashtable;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;

public class LineStyle
extends Storable {
    private static final int COLOR_WHITE = -1;
    private static final int COLOR_BLACK = -16777216;
    public static String KEY_CP_ALTITUDE_MANUAL = "alt_man";
    public static String KEY_CP_ALTITUDE_MANUAL_MIN = "alt_man_min";
    public static String KEY_CP_ALTITUDE_MANUAL_MAX = "alt_man_max";
    public static String KEY_CP_SLOPE_MANUAL = "slo_man";
    public static String KEY_CP_SLOPE_MANUAL_MIN = "slo_man_min";
    public static String KEY_CP_SLOPE_MANUAL_MAX = "slo_man_max";
    private boolean mDrawBase = true;
    private int mColorBase = -16777216;
    private boolean mDrawSymbol = false;
    private int mColorSymbol = -1;
    private Symbol mSymbol = Symbol.DOTTED;
    private Coloring mColoring = Coloring.SIMPLE;
    private Hashtable<String, String> mColoringParams = new Hashtable();
    private float mWidth = 1.0f;
    private Units mUnits = Units.PIXELS;
    private boolean mDrawOutline = false;
    private int mColorOutline = -1;
    private boolean mDrawFill = false;
    private int mColorFill = -1;

    public boolean isDrawBase() {
        return this.mDrawBase;
    }

    public LineStyle setDrawBase(boolean drawBase) {
        this.mDrawBase = drawBase;
        return this;
    }

    public int getColorBase() {
        return this.mColorBase;
    }

    public LineStyle setColorBase(int colorBase) {
        this.mColorBase = colorBase;
        return this;
    }

    public boolean isDrawSymbol() {
        return this.mDrawSymbol;
    }

    public LineStyle setDrawSymbol(boolean drawSymbol) {
        this.mDrawSymbol = drawSymbol;
        return this;
    }

    public int getColorSymbol() {
        return this.mColorSymbol;
    }

    public LineStyle setColorSymbol(int colorSymbol) {
        this.mColorSymbol = colorSymbol;
        return this;
    }

    public Symbol getSymbol() {
        return this.mSymbol;
    }

    public LineStyle setSymbol(Symbol symbol) {
        this.mSymbol = symbol;
        return this;
    }

    public Coloring getColoring() {
        return this.mColoring;
    }

    public LineStyle setColoring(Coloring coloring) {
        this.mColoring = coloring;
        return this;
    }

    public String getColoringParam(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        return this.mColoringParams.get(key);
    }

    public LineStyle setColoringParam(String key, String value) {
        if (key == null || key.length() == 0) {
            return this;
        }
        if (value == null) {
            this.mColoringParams.remove(key);
        } else {
            this.mColoringParams.put(key, value);
        }
        return this;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public LineStyle setWidth(float width) {
        this.mWidth = width;
        return this;
    }

    public Units getUnits() {
        return this.mUnits;
    }

    public LineStyle setUnits(Units units) {
        this.mUnits = units;
        return this;
    }

    public boolean isDrawOutline() {
        return this.mDrawOutline;
    }

    public LineStyle setDrawOutline(boolean drawOutline) {
        this.mDrawOutline = drawOutline;
        return this;
    }

    public int getColorOutline() {
        return this.mColorOutline;
    }

    public LineStyle setColorOutline(int colorOutline) {
        this.mColorOutline = colorOutline;
        return this;
    }

    public boolean isDrawFill() {
        return this.mDrawFill;
    }

    public LineStyle setDrawFill(boolean drawFill) {
        this.mDrawFill = drawFill;
        return this;
    }

    public int getColorFill() {
        return this.mColorFill;
    }

    public LineStyle setColorFill(int colorFill) {
        this.mColorFill = colorFill;
        return this;
    }

    public boolean isDrawDefined() {
        return this.isDrawBase() || this.isDrawSymbol() || this.isDrawFill();
    }

    @Override
    protected int getVersion() {
        return 0;
    }

    @Override
    protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
        this.mDrawBase = dr.readBoolean();
        this.mColorBase = dr.readInt();
        this.mDrawSymbol = dr.readBoolean();
        this.mColorSymbol = dr.readInt();
        this.mSymbol = Symbol.valueOf(dr.readString());
        this.mColoring = Coloring.valueOf(dr.readString());
        int m = dr.readInt();
        for (int i = 0; i < m; ++i) {
            this.mColoringParams.put(dr.readString(), dr.readString());
        }
        this.mWidth = dr.readFloat();
        this.mUnits = Units.valueOf(dr.readString());
        this.mDrawOutline = dr.readBoolean();
        this.mColorOutline = dr.readInt();
        this.mDrawFill = dr.readBoolean();
        this.mColorFill = dr.readInt();
    }

    @Override
    protected void writeObject(DataWriterBigEndian dw) throws IOException {
        dw.writeBoolean(this.mDrawBase);
        dw.writeInt(this.mColorBase);
        dw.writeBoolean(this.mDrawSymbol);
        dw.writeInt(this.mColorSymbol);
        dw.writeString(this.mSymbol.name());
        dw.writeString(this.mColoring.name());
        dw.writeInt(this.mColoringParams.size());
        for (String key : this.mColoringParams.keySet()) {
            dw.writeString(key);
            dw.writeString(this.mColoringParams.get(key));
        }
        dw.writeFloat(this.mWidth);
        dw.writeString(this.mUnits.name());
        dw.writeBoolean(this.mDrawOutline);
        dw.writeInt(this.mColorOutline);
        dw.writeBoolean(this.mDrawFill);
        dw.writeInt(this.mColorFill);
    }

    public static enum Units {
        PIXELS,
        METRES;

    }

    public static enum Coloring {
        SIMPLE,
        BY_SPEED,
        BY_SPEED_CHANGE,
        BY_ALTITUDE,
        BY_SLOPE,
        BY_ACCURACY,
        BY_HRM,
        BY_CADENCE;

    }

    public static enum Symbol {
        DOTTED,
        DASHED_1,
        DASHED_2,
        DASHED_3,
        SPECIAL_1,
        SPECIAL_2,
        SPECIAL_3,
        ARROW_1,
        ARROW_2,
        ARROW_3,
        CROSS_1,
        CROSS_2;

    }
}

